/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.throttle;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.congestion.CongestionLevelStarts;
import com.hedera.hapi.node.state.throttles.ThrottleUsageSnapshot;
import com.hedera.hapi.node.state.throttles.ThrottleUsageSnapshots;
import com.hedera.hapi.node.transaction.ThrottleDefinitions;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.fees.congestion.CongestionMultipliers;
import com.hedera.node.app.hapi.utils.throttles.DeterministicThrottle;
import com.hedera.node.app.hapi.utils.throttles.LeakyBucketDeterministicThrottle;
import com.hedera.node.app.hapi.utils.throttles.OpsDurationDeterministicThrottle;
import com.hedera.node.app.records.BlockRecordService;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.throttle.ThrottleAccumulator;
import com.hedera.node.app.throttle.ThrottleParser;
import com.hedera.node.app.throttle.annotations.BackendThrottle;
import com.hedera.node.app.throttle.annotations.IngestThrottle;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.State;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class ThrottleServiceManager {
    private static final Logger log = LogManager.getLogger(ThrottleServiceManager.class);
    private final ThrottleParser throttleParser;
    private final ThrottleAccumulator ingestThrottle;
    private final ThrottleAccumulator backendThrottle;
    private final CongestionMultipliers congestionMultipliers;
    @Nullable
    private ThrottleDefinitions activeDefinitions;

    @Inject
    public ThrottleServiceManager(@NonNull ThrottleParser throttleParser, @IngestThrottle @NonNull ThrottleAccumulator ingestThrottle, @BackendThrottle @NonNull ThrottleAccumulator backendThrottle, @NonNull CongestionMultipliers congestionMultipliers) {
        this.throttleParser = throttleParser;
        this.ingestThrottle = Objects.requireNonNull(ingestThrottle);
        this.backendThrottle = Objects.requireNonNull(backendThrottle);
        this.congestionMultipliers = Objects.requireNonNull(congestionMultipliers);
    }

    public void init(@NonNull State state, @NonNull Bytes throttleDefinitions) {
        Objects.requireNonNull(state);
        this.applyGasConfig();
        this.applyBytesConfig();
        this.applyOpsDurationConfig();
        this.rebuildThrottlesFrom(throttleDefinitions);
        this.congestionMultipliers.resetExpectations();
        ReadableStates serviceStates = state.getReadableStates("CongestionThrottleService");
        this.resetThrottlesFromUsageSnapshots(serviceStates);
        this.syncFromCongestionLevelStarts(serviceStates);
    }

    @NonNull
    public ThrottleDefinitions activeThrottleDefinitionsOrThrow() {
        return Objects.requireNonNull(this.activeDefinitions);
    }

    public void saveThrottleSnapshotsAndCongestionLevelStartsTo(@NonNull State state) {
        Objects.requireNonNull(state);
        WritableStates serviceStates = state.getWritableStates("CongestionThrottleService");
        this.saveThrottleSnapshotsTo(serviceStates);
        this.saveCongestionLevelStartsTo(serviceStates);
    }

    public void refreshThrottleConfiguration() {
        this.applyGasConfig();
        this.applyBytesConfig();
        this.applyOpsDurationConfig();
        this.congestionMultipliers.resetExpectations();
    }

    public ResponseCodeEnum recreateThrottles(@NonNull Bytes encoded) {
        ThrottleParser.ValidatedThrottles validatedThrottles = this.rebuildThrottlesFrom(encoded);
        this.congestionMultipliers.resetExpectations();
        return validatedThrottles.successStatus();
    }

    public int numImplicitCreations(@NonNull TransactionBody body, @NonNull ReadableAccountStore accountStore) {
        return this.backendThrottle.getImplicitCreationsCount(body, accountStore);
    }

    public int numAutoAssociations(@NonNull TransactionBody body, @NonNull ReadableTokenRelationStore relationStore) {
        return this.backendThrottle.getAutoAssociationsCount(body, relationStore);
    }

    public void updateAllMetrics() {
        this.ingestThrottle.updateAllMetrics();
        this.backendThrottle.updateAllMetrics();
    }

    private void saveThrottleSnapshotsTo(@NonNull WritableStates serviceStates) {
        List hapiThrottleSnapshots;
        List<DeterministicThrottle> hapiThrottles = this.backendThrottle.allActiveThrottles();
        if (hapiThrottles.isEmpty()) {
            hapiThrottleSnapshots = Collections.emptyList();
        } else {
            hapiThrottleSnapshots = new ArrayList();
            for (DeterministicThrottle throttle : hapiThrottles) {
                hapiThrottleSnapshots.add(throttle.usageSnapshot());
            }
        }
        LeakyBucketDeterministicThrottle gasThrottle = this.backendThrottle.gasLimitThrottle();
        ThrottleUsageSnapshot gasThrottleSnapshot = gasThrottle.usageSnapshot();
        OpsDurationDeterministicThrottle opsDurationThrottle = this.backendThrottle.opsDurationThrottle();
        ThrottleUsageSnapshot opsDurationThrottleSnapshot = opsDurationThrottle.usageSnapshot();
        WritableSingletonState throttleSnapshots = serviceStates.getSingleton("THROTTLE_USAGE_SNAPSHOTS");
        throttleSnapshots.put((Object)new ThrottleUsageSnapshots(hapiThrottleSnapshots, gasThrottleSnapshot, opsDurationThrottleSnapshot));
    }

    private void saveCongestionLevelStartsTo(@NonNull WritableStates serviceStates) {
        WritableSingletonState congestionLevelStarts = serviceStates.getSingleton("CONGESTION_LEVEL_STARTS");
        congestionLevelStarts.put((Object)new CongestionLevelStarts(ThrottleServiceManager.translateToList(this.congestionMultipliers.entityUtilizationCongestionStarts()), ThrottleServiceManager.translateToList(this.congestionMultipliers.gasThrottleMultiplierCongestionStarts())));
    }

    @NonNull
    private ThrottleParser.ValidatedThrottles rebuildThrottlesFrom(@NonNull Bytes encoded) {
        ThrottleParser.ValidatedThrottles validatedThrottles = this.throttleParser.parse(encoded);
        this.ingestThrottle.rebuildFor(validatedThrottles.throttleDefinitions());
        this.backendThrottle.rebuildFor(validatedThrottles.throttleDefinitions());
        this.activeDefinitions = validatedThrottles.throttleDefinitions();
        return validatedThrottles;
    }

    private void applyGasConfig() {
        this.ingestThrottle.applyGasConfig();
        this.backendThrottle.applyGasConfig();
    }

    private void applyBytesConfig() {
        this.ingestThrottle.applyBytesConfig();
    }

    private void applyOpsDurationConfig() {
        this.backendThrottle.applyDurationConfig();
    }

    private void syncFromCongestionLevelStarts(@NonNull ReadableStates serviceStates) {
        CongestionStarts congestionStarts = CongestionStarts.from((ReadableSingletonState<CongestionLevelStarts>)serviceStates.getSingleton("CONGESTION_LEVEL_STARTS"));
        if (congestionStarts.cryptoTransferLevelStarts().length > 0) {
            this.congestionMultipliers.resetUtilizationScaledThrottleMultiplierStarts(congestionStarts.cryptoTransferLevelStarts());
        }
        if (congestionStarts.gasLevelStarts().length > 0) {
            this.congestionMultipliers.resetGasThrottleMultiplierStarts(congestionStarts.gasLevelStarts());
        }
    }

    private void resetThrottlesFromUsageSnapshots(@NonNull ReadableStates serviceStates) {
        ReadableSingletonState usageSnapshotsState = serviceStates.getSingleton("THROTTLE_USAGE_SNAPSHOTS");
        ThrottleUsageSnapshots usageSnapshots = Objects.requireNonNull((ThrottleUsageSnapshots)usageSnapshotsState.get());
        ThrottleServiceManager.safeResetThrottles(this.backendThrottle.allActiveThrottles(), usageSnapshots.tpsThrottles());
        if (usageSnapshots.hasGasThrottle()) {
            this.backendThrottle.gasLimitThrottle().resetUsageTo(usageSnapshots.gasThrottleOrThrow());
        }
        if (usageSnapshots.hasEvmOpsDurationThrottle()) {
            this.backendThrottle.opsDurationThrottle().resetUsageTo(usageSnapshots.evmOpsDurationThrottleOrThrow());
        }
    }

    public void resetThrottlesUnconditionally(@NonNull ReadableStates serviceStates) {
        ReadableSingletonState usageSnapshotsState = serviceStates.getSingleton("THROTTLE_USAGE_SNAPSHOTS");
        ThrottleUsageSnapshots usageSnapshots = Objects.requireNonNull((ThrottleUsageSnapshots)usageSnapshotsState.get());
        ThrottleServiceManager.resetUnconditionally(this.backendThrottle.allActiveThrottles(), usageSnapshots.tpsThrottles());
        if (usageSnapshots.hasGasThrottle()) {
            this.backendThrottle.gasLimitThrottle().resetUsageTo(usageSnapshots.gasThrottleOrThrow());
        }
        if (usageSnapshots.hasEvmOpsDurationThrottle()) {
            this.backendThrottle.opsDurationThrottle().resetUsageTo(usageSnapshots.evmOpsDurationThrottleOrThrow());
        }
    }

    public void reclaimFrontendThrottleCapacity(int numCapacity, HederaFunctionality hederaFunctionality) {
        try {
            this.ingestThrottle.leakCapacityForNOfUnscaled(numCapacity, hederaFunctionality);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NonNull
    private static List<Timestamp> translateToList(@NonNull Instant[] levelStartTimes) {
        ArrayList<Timestamp> list = new ArrayList<Timestamp>(levelStartTimes.length);
        for (Instant startTime : levelStartTimes) {
            list.add(startTime == null ? BlockRecordService.EPOCH : new Timestamp(startTime.getEpochSecond(), startTime.getNano()));
        }
        return list;
    }

    private static void safeResetThrottles(List<DeterministicThrottle> throttles, List<ThrottleUsageSnapshot> snapshots) {
        if (throttles.size() != snapshots.size()) {
            return;
        }
        List<ThrottleUsageSnapshot> currentSnapshots = throttles.stream().map(DeterministicThrottle::usageSnapshot).toList();
        int n = throttles.size();
        for (int i = 0; i < n; ++i) {
            try {
                throttles.get(i).resetUsageTo(snapshots.get(i));
                continue;
            }
            catch (Exception e) {
                log.warn("Saved usage snapshot @ index {} was not compatible with the corresponding active throttle ({}), not performing a reset !", (Object)i, (Object)e.getMessage());
                ThrottleServiceManager.resetUnconditionally(throttles, currentSnapshots);
                break;
            }
        }
    }

    private static void resetUnconditionally(List<DeterministicThrottle> throttles, List<ThrottleUsageSnapshot> knownCompatible) {
        int n = knownCompatible.size();
        for (int i = 0; i < n; ++i) {
            throttles.get(i).resetUsageTo(knownCompatible.get(i));
        }
    }

    @NonNull
    private static Instant[] asMultiplierStarts(@NonNull List<Timestamp> times) {
        int n = times.size();
        Instant[] starts = new Instant[n];
        for (int i = 0; i < n; ++i) {
            Timestamp time = times.get(i);
            if (BlockRecordService.EPOCH.equals((Object)time)) continue;
            starts[i] = Instant.ofEpochSecond(time.seconds(), time.nanos());
        }
        return starts;
    }

    private record CongestionStarts(Instant[] cryptoTransferLevelStarts, Instant[] gasLevelStarts) {
        static CongestionStarts from(@NonNull ReadableSingletonState<CongestionLevelStarts> congestionLevelStarts) {
            CongestionLevelStarts sourceStarts = Objects.requireNonNull((CongestionLevelStarts)congestionLevelStarts.get());
            return new CongestionStarts(ThrottleServiceManager.asMultiplierStarts(sourceStarts.genericLevelStarts()), ThrottleServiceManager.asMultiplierStarts(sourceStarts.gasLevelStarts()));
        }
    }
}

