/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.stack;

import com.hedera.node.app.workflows.handle.stack.WritableStatesStack;
import com.swirlds.state.spi.WritableKVState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class WritableKVStateStack<K, V>
implements WritableKVState<K, V> {
    private final WritableStatesStack writableStatesStack;
    private final String serviceName;
    private final String stateKey;

    public WritableKVStateStack(@NonNull WritableStatesStack writableStatesStack, @NonNull String serviceName, @NonNull String stateKey) {
        this.writableStatesStack = Objects.requireNonNull(writableStatesStack, "writableStatesStack must not be null");
        this.serviceName = Objects.requireNonNull(serviceName, "serviceName must not be null");
        this.stateKey = Objects.requireNonNull(stateKey, "stateKey must not be null");
    }

    @NonNull
    private WritableKVState<K, V> getCurrent() {
        return this.writableStatesStack.getCurrent().get(this.stateKey);
    }

    @NonNull
    public String getServiceName() {
        return this.serviceName;
    }

    @NonNull
    public String getStateKey() {
        return this.stateKey;
    }

    @Nullable
    public V get(@NonNull K key) {
        return (V)this.getCurrent().get(key);
    }

    @Nullable
    public V getOriginalValue(@NonNull K key) {
        return (V)this.writableStatesStack.getRoot().get(this.stateKey).get(key);
    }

    public void put(@NonNull K key, @NonNull V value) {
        this.getCurrent().put(key, value);
    }

    public void remove(@NonNull K key) {
        this.getCurrent().remove(key);
    }

    @NonNull
    public Iterator<K> keys() {
        return this.getCurrent().keys();
    }

    @NonNull
    public Set<K> modifiedKeys() {
        return this.getCurrent().modifiedKeys();
    }

    @NonNull
    public Set<K> readKeys() {
        return this.getCurrent().readKeys();
    }

    @Deprecated
    public long size() {
        return this.getCurrent().size();
    }
}

