/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.schedule.impl;

import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TimestampSeconds;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.hapi.node.state.schedule.Schedule;
import com.hedera.hapi.node.state.schedule.ScheduledCounts;
import com.hedera.hapi.node.state.schedule.ScheduledOrder;
import com.hedera.hapi.node.state.throttles.ThrottleUsageSnapshots;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.schedule.WritableScheduleStore;
import com.hedera.node.app.service.schedule.impl.ReadableScheduleStoreImpl;
import com.hedera.node.app.service.schedule.impl.ScheduleStoreUtility;
import com.hedera.node.app.spi.ids.ReadableEntityCounters;
import com.hedera.node.app.spi.ids.WritableEntityCounters;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WritableScheduleStoreImpl
extends ReadableScheduleStoreImpl
implements WritableScheduleStore {
    private static final Logger logger = LogManager.getLogger(WritableScheduleStoreImpl.class);
    private final WritableKVState<ScheduleID, Schedule> schedulesByIdMutable;
    private final WritableKVState<ProtoBytes, ScheduleID> scheduleIdByEqualityMutable;
    private final WritableKVState<TimestampSeconds, ScheduledCounts> scheduleCountsMutable;
    private final WritableKVState<TimestampSeconds, ThrottleUsageSnapshots> scheduleUsagesMutable;
    private final WritableKVState<ScheduledOrder, ScheduleID> scheduleOrdersMutable;
    private final WritableEntityCounters entityCounters;

    public WritableScheduleStoreImpl(@NonNull WritableStates states, WritableEntityCounters entityCounters) {
        super((ReadableStates)states, (ReadableEntityCounters)entityCounters);
        this.schedulesByIdMutable = states.get("SCHEDULES_BY_ID");
        this.scheduleCountsMutable = states.get("SCHEDULED_COUNTS");
        this.scheduleOrdersMutable = states.get("SCHEDULED_ORDERS");
        this.scheduleUsagesMutable = states.get("SCHEDULED_USAGES");
        this.scheduleIdByEqualityMutable = states.get("SCHEDULE_ID_BY_EQUALITY");
        this.entityCounters = entityCounters;
    }

    @NonNull
    public Schedule delete(@Nullable ScheduleID scheduleId, @NonNull Instant consensusTime) {
        Objects.requireNonNull(consensusTime);
        Objects.requireNonNull(scheduleId);
        Schedule schedule = (Schedule)this.schedulesByIdMutable.get((Object)scheduleId);
        if (schedule == null) {
            throw new IllegalStateException("Schedule to be deleted, %1$s, not found in state.".formatted(scheduleId));
        }
        Schedule deletedSchedule = this.markDeleted(schedule, consensusTime);
        this.schedulesByIdMutable.put((Object)scheduleId, (Object)deletedSchedule);
        return deletedSchedule;
    }

    public void put(@NonNull Schedule schedule) {
        Objects.requireNonNull(schedule);
        ScheduleID scheduleId = schedule.scheduleIdOrThrow();
        Schedule extant = (Schedule)this.schedulesByIdMutable.get((Object)scheduleId);
        this.schedulesByIdMutable.put((Object)scheduleId, (Object)schedule);
        if (extant != null) {
            return;
        }
        ProtoBytes equalityKey = new ProtoBytes(ScheduleStoreUtility.calculateBytesHash(schedule));
        this.scheduleIdByEqualityMutable.put((Object)equalityKey, (Object)scheduleId);
        long second = schedule.calculatedExpirationSecond();
        TimestampSeconds countsKey = new TimestampSeconds(second);
        ScheduledCounts oldCounts = (ScheduledCounts)this.scheduleCountsMutable.get((Object)countsKey);
        ScheduledCounts counts = oldCounts == null ? new ScheduledCounts(1, 0) : new ScheduledCounts(oldCounts.numberScheduled() + 1, oldCounts.numberProcessed());
        this.scheduleCountsMutable.put((Object)countsKey, (Object)counts);
        ScheduledOrder orderKey = new ScheduledOrder(second, counts.numberScheduled() - 1);
        this.scheduleOrdersMutable.put((Object)orderKey, (Object)schedule.scheduleIdOrThrow());
    }

    public void putAndIncrementCount(@NonNull Schedule schedule) {
        this.put(schedule);
        this.entityCounters.incrementEntityTypeCount(EntityType.SCHEDULE);
    }

    public boolean purgeByOrder(@NonNull ScheduledOrder order) {
        Objects.requireNonNull(order);
        ScheduleID scheduleId = this.getByOrder(order);
        if (scheduleId != null) {
            TimestampSeconds key = new TimestampSeconds(order.expirySecond());
            ScheduledCounts counts = Objects.requireNonNull((ScheduledCounts)this.scheduleCountsMutable.get((Object)key));
            if (order.orderNumber() != counts.numberProcessed()) {
                throw new IllegalStateException("Order %s is not next in counts %s".formatted(order, counts));
            }
            this.purge(scheduleId);
            this.scheduleOrdersMutable.remove((Object)order);
            ScheduledCounts newCounts = counts.copyBuilder().numberProcessed(counts.numberProcessed() + 1).build();
            if (newCounts.numberProcessed() < newCounts.numberScheduled()) {
                this.scheduleCountsMutable.put((Object)key, (Object)newCounts);
                return false;
            }
            this.scheduleCountsMutable.remove((Object)key);
            this.scheduleUsagesMutable.remove((Object)key);
        }
        return true;
    }

    public void trackUsage(long consensusSecond, @NonNull ThrottleUsageSnapshots usageSnapshots) {
        Objects.requireNonNull(usageSnapshots);
        this.scheduleUsagesMutable.put((Object)new TimestampSeconds(consensusSecond), (Object)usageSnapshots);
    }

    public void purgeExpiredRangeClosed(long start, long end) {
        for (long i = start; i <= end; ++i) {
            TimestampSeconds countsAndUsagesKey = new TimestampSeconds(i);
            ScheduledCounts counts = (ScheduledCounts)this.scheduleCountsMutable.get((Object)countsAndUsagesKey);
            if (counts == null) continue;
            int n = counts.numberScheduled();
            for (int j = 0; j < n; ++j) {
                ScheduledOrder orderKey = new ScheduledOrder(i, j);
                ScheduleID scheduleId = Objects.requireNonNull((ScheduleID)this.scheduleOrdersMutable.get((Object)orderKey));
                this.purge(scheduleId);
                this.scheduleOrdersMutable.remove((Object)orderKey);
            }
            this.scheduleCountsMutable.remove((Object)countsAndUsagesKey);
            this.scheduleUsagesMutable.remove((Object)countsAndUsagesKey);
        }
    }

    private void purge(@NonNull ScheduleID scheduleId) {
        Schedule schedule = (Schedule)this.schedulesByIdMutable.get((Object)scheduleId);
        if (schedule != null) {
            ProtoBytes hash = new ProtoBytes(ScheduleStoreUtility.calculateBytesHash(schedule));
            this.scheduleIdByEqualityMutable.remove((Object)hash);
        } else {
            logger.error("Schedule {} not found in state schedulesByIdMutable.", (Object)scheduleId);
        }
        this.schedulesByIdMutable.remove((Object)scheduleId);
        this.entityCounters.decrementEntityTypeCounter(EntityType.SCHEDULE);
        logger.debug("Purging expired schedule {} from state.", (Object)scheduleId);
    }

    @NonNull
    private Schedule markDeleted(Schedule schedule, Instant consensusTime) {
        Timestamp consensusTimestamp = new Timestamp(consensusTime.getEpochSecond(), consensusTime.getNano());
        return new Schedule(schedule.scheduleId(), true, schedule.executed(), schedule.waitForExpiry(), schedule.memo(), schedule.schedulerAccountId(), schedule.payerAccountId(), schedule.adminKey(), schedule.scheduleValidStart(), schedule.providedExpirationSecond(), schedule.calculatedExpirationSecond(), consensusTimestamp, schedule.scheduledTransaction(), schedule.originalCreateTransaction(), schedule.signatories());
    }
}

