/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.schedule.impl.schemas;

import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.base.TimestampSeconds;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.hapi.node.state.schedule.ScheduledCounts;
import com.hedera.hapi.node.state.schedule.ScheduledOrder;
import com.hedera.hapi.node.state.throttles.ThrottleUsageSnapshots;
import com.hedera.pbj.runtime.Codec;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class V0570ScheduleSchema
extends Schema {
    private static final Logger log = LogManager.getLogger(V0570ScheduleSchema.class);
    private static final long MAX_SCHEDULED_COUNTS = 50000L;
    private static final long MAX_SCHEDULED_ORDERS = 50000L;
    private static final long MAX_SCHEDULED_USAGES = 50000L;
    private static final long MAX_SCHEDULE_ID_BY_EQUALITY = 50000L;
    private static final SemanticVersion VERSION = SemanticVersion.newBuilder().major(0).minor(57).patch(0).build();
    public static final String SCHEDULED_COUNTS_KEY = "SCHEDULED_COUNTS";
    public static final String SCHEDULED_ORDERS_KEY = "SCHEDULED_ORDERS";
    public static final String SCHEDULED_USAGES_KEY = "SCHEDULED_USAGES";
    public static final String SCHEDULE_ID_BY_EQUALITY_KEY = "SCHEDULE_ID_BY_EQUALITY";

    public V0570ScheduleSchema() {
        super(VERSION);
    }

    @NonNull
    public Set<StateDefinition> statesToCreate() {
        return Set.of(V0570ScheduleSchema.scheduleIdByEquality(), V0570ScheduleSchema.scheduledOrders(), V0570ScheduleSchema.scheduledCounts(), V0570ScheduleSchema.scheduledUsages());
    }

    @NonNull
    public Set<String> statesToRemove() {
        return Set.of("SCHEDULES_BY_EXPIRY_SEC", "SCHEDULES_BY_EQUALITY");
    }

    private static StateDefinition<TimestampSeconds, ScheduledCounts> scheduledCounts() {
        return StateDefinition.onDisk((String)SCHEDULED_COUNTS_KEY, (Codec)TimestampSeconds.PROTOBUF, (Codec)ScheduledCounts.PROTOBUF, (long)50000L);
    }

    private static StateDefinition<ScheduledOrder, ScheduleID> scheduledOrders() {
        return StateDefinition.onDisk((String)SCHEDULED_ORDERS_KEY, (Codec)ScheduledOrder.PROTOBUF, (Codec)ScheduleID.PROTOBUF, (long)50000L);
    }

    private static StateDefinition<TimestampSeconds, ThrottleUsageSnapshots> scheduledUsages() {
        return StateDefinition.onDisk((String)SCHEDULED_USAGES_KEY, (Codec)TimestampSeconds.PROTOBUF, (Codec)ThrottleUsageSnapshots.PROTOBUF, (long)50000L);
    }

    private static StateDefinition<ProtoBytes, ScheduleID> scheduleIdByEquality() {
        return StateDefinition.onDisk((String)SCHEDULE_ID_BY_EQUALITY_KEY, (Codec)ProtoBytes.PROTOBUF, (Codec)ScheduleID.PROTOBUF, (long)50000L);
    }
}

