/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.fee;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.hapi.utils.fee.FeeObject;
import com.hederahashgraph.api.proto.java.ContractFunctionResult;
import com.hederahashgraph.api.proto.java.ExchangeRate;
import com.hederahashgraph.api.proto.java.FeeComponents;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.Key;
import com.hederahashgraph.api.proto.java.ResponseType;
import com.hederahashgraph.api.proto.java.Transaction;
import com.hederahashgraph.api.proto.java.TransactionBody;
import com.hederahashgraph.api.proto.java.TransactionOrBuilder;
import com.hederahashgraph.api.proto.java.TransactionRecord;
import java.math.BigInteger;
import java.util.List;

public class FeeBuilder {
    public static final long MAX_ENTITY_LIFETIME = 3153600000L;
    public static final int LONG_SIZE = 8;
    public static final int FEE_MATRICES_CONST = 1;
    public static final int INT_SIZE = 4;
    public static final int BOOL_SIZE = 4;
    public static final long SOLIDITY_ADDRESS = 20L;
    public static final int KEY_SIZE = 32;
    public static final int TX_HASH_SIZE = 48;
    public static final long RECEIPT_STORAGE_TIME_SEC = 180L;
    public static final int THRESHOLD_STORAGE_TIME_SEC = 90000;
    public static final int FEE_DIVISOR_FACTOR = 1000;
    public static final int HRS_DIVISOR = 3600;
    public static final int BASIC_ENTITY_ID_SIZE = 24;
    public static final long BASIC_RICH_INSTANT_SIZE = 12L;
    public static final int BASIC_ACCOUNT_AMT_SIZE = 32;
    public static final int BASIC_TX_ID_SIZE = 32;
    public static final int EXCHANGE_RATE_SIZE = 16;
    public static final int CRYPTO_ALLOWANCE_SIZE = 36;
    public static final int TOKEN_ALLOWANCE_SIZE = 40;
    public static final int NFT_ALLOWANCE_SIZE = 36;
    public static final int NFT_DELETE_ALLOWANCE_SIZE = 48;
    public static final int BASIC_RECEIPT_SIZE = 36;
    public static final int BASIC_TX_BODY_SIZE = 76;
    public static final int STATE_PROOF_SIZE = 2000;
    public static final int BASE_FILEINFO_SIZE = 44;
    public static final int BASIC_ACCOUNT_SIZE = 68;
    public static final long BASIC_QUERY_RES_HEADER = 16L;
    public static final long BASIC_QUERY_HEADER = 212L;
    public static final int BASIC_CONTRACT_CREATE_SIZE = 72;
    public static final long BASIC_CONTRACT_INFO_SIZE = 100L;
    public static final int BASIC_TX_RECORD_SIZE = 132;

    public static long getComponentFeeInTinyCents(FeeComponents componentCoefficients, FeeComponents componentMetrics) {
        long bytesUsageFee = componentCoefficients.getBpt() * componentMetrics.getBpt();
        long verificationFee = componentCoefficients.getVpt() * componentMetrics.getVpt();
        long ramStorageFee = componentCoefficients.getRbh() * componentMetrics.getRbh();
        long storageFee = componentCoefficients.getSbh() * componentMetrics.getSbh();
        long evmGasFee = componentCoefficients.getGas() * componentMetrics.getGas();
        long txValueFee = Math.round((float)(componentCoefficients.getTv() * componentMetrics.getTv()) / 1000.0f);
        long bytesResponseFee = componentCoefficients.getBpr() * componentMetrics.getBpr();
        long storageBytesResponseFee = componentCoefficients.getSbpr() * componentMetrics.getSbpr();
        long componentUsage = componentCoefficients.getConstant() * componentMetrics.getConstant();
        long totalComponentFee = componentUsage + (bytesUsageFee + verificationFee + ramStorageFee + storageFee + evmGasFee + txValueFee + bytesResponseFee + storageBytesResponseFee);
        if (totalComponentFee < componentCoefficients.getMin()) {
            totalComponentFee = componentCoefficients.getMin();
        } else if (totalComponentFee > componentCoefficients.getMax()) {
            totalComponentFee = componentCoefficients.getMax();
        }
        return Math.max(totalComponentFee > 0L ? 1L : 0L, totalComponentFee / 1000L);
    }

    public static long getTotalFeeforRequest(FeeData feeCoefficients, FeeData componentMetrics, ExchangeRate exchangeRate) {
        FeeObject feeObject = FeeBuilder.getFeeObject(feeCoefficients, componentMetrics, exchangeRate);
        return feeObject.serviceFee() + feeObject.nodeFee() + feeObject.networkFee();
    }

    public static FeeObject getFeeObject(FeeData feeData, FeeData feeMatrices, ExchangeRate exchangeRate, long multiplier) {
        long networkFee = FeeBuilder.getComponentFeeInTinyCents(feeData.getNetworkdata(), feeMatrices.getNetworkdata());
        long nodeFee = FeeBuilder.getComponentFeeInTinyCents(feeData.getNodedata(), feeMatrices.getNodedata());
        long serviceFee = FeeBuilder.getComponentFeeInTinyCents(feeData.getServicedata(), feeMatrices.getServicedata());
        networkFee = FeeBuilder.getTinybarsFromTinyCents(exchangeRate, networkFee) * multiplier;
        nodeFee = FeeBuilder.getTinybarsFromTinyCents(exchangeRate, nodeFee) * multiplier;
        serviceFee = FeeBuilder.getTinybarsFromTinyCents(exchangeRate, serviceFee) * multiplier;
        return new FeeObject(nodeFee, networkFee, serviceFee);
    }

    public static FeeObject getFeeObject(FeeData feeData, FeeData feeMatrices, ExchangeRate exchangeRate) {
        return FeeBuilder.getFeeObject(feeData, feeMatrices, exchangeRate, 1L);
    }

    public static long getCommonTransactionBodyBytes(TransactionBody txBody) {
        int memoSize = 0;
        if (txBody.getMemo() != null) {
            memoSize = txBody.getMemoBytes().size();
        }
        return 76L + (long)memoSize;
    }

    public static int getAccountKeyStorageSize(Key key) {
        if (key == null) {
            return 0;
        }
        if (Key.getDefaultInstance().equals((Object)key)) {
            return 0;
        }
        int[] countKeyMetatData = new int[]{0, 0};
        countKeyMetatData = FeeBuilder.calculateKeysMetadata(key, countKeyMetatData);
        return countKeyMetatData[0] * 32 + countKeyMetatData[1] * 4;
    }

    public static int[] calculateKeysMetadata(Key key, int[] count) {
        int[] workingCount = count;
        if (key.hasKeyList()) {
            List keyList = key.getKeyList().getKeysList();
            for (Key value : keyList) {
                workingCount = FeeBuilder.calculateKeysMetadata(value, workingCount);
            }
        } else if (key.hasThresholdKey()) {
            List keyList = key.getThresholdKey().getKeys().getKeysList();
            workingCount[1] = workingCount[1] + 1;
            for (Key value : keyList) {
                workingCount = FeeBuilder.calculateKeysMetadata(value, workingCount);
            }
        } else {
            workingCount[0] = workingCount[0] + 1;
        }
        return workingCount;
    }

    public static FeeData getCostForQueryByIdOnly() {
        return FeeData.getDefaultInstance();
    }

    public static int getSignatureCount(Transaction transaction) {
        try {
            return CommonUtils.extractSignatureMap((TransactionOrBuilder)transaction).getSigPairCount();
        }
        catch (InvalidProtocolBufferException ignored) {
            return 0;
        }
    }

    public static int getSignatureSize(Transaction transaction) {
        try {
            return CommonUtils.extractSignatureMap((TransactionOrBuilder)transaction).getSerializedSize();
        }
        catch (InvalidProtocolBufferException ignored) {
            return 0;
        }
    }

    public static long getTinybarsFromTinyCents(ExchangeRate exchangeRate, long tinyCentsFee) {
        return FeeBuilder.getAFromB(tinyCentsFee, exchangeRate.getHbarEquiv(), exchangeRate.getCentEquiv());
    }

    private static long getAFromB(long bAmount, int aEquiv, int bEquiv) {
        BigInteger aMultiplier = BigInteger.valueOf(aEquiv);
        BigInteger bDivisor = BigInteger.valueOf(bEquiv);
        return BigInteger.valueOf(bAmount).multiply(aMultiplier).divide(bDivisor).longValueExact();
    }

    public static FeeData getFeeDataMatrices(FeeComponents feeComponents, int payerVpt, long rbsNetwork) {
        long rbh = Math.max(feeComponents.getRbh() > 0L ? 1L : 0L, feeComponents.getRbh() / 3600L);
        long sbh = Math.max(feeComponents.getSbh() > 0L ? 1L : 0L, feeComponents.getSbh() / 3600L);
        long rbhNetwork = Math.max(rbsNetwork > 0L ? 1L : 0L, rbsNetwork / 3600L);
        FeeComponents feeMatricesForTxService = FeeComponents.newBuilder().setConstant(1L).setRbh(rbh).setSbh(sbh).setTv(feeComponents.getTv()).build();
        FeeComponents feeMatricesForTxNetwork = FeeComponents.newBuilder().setConstant(1L).setBpt(feeComponents.getBpt()).setVpt(feeComponents.getVpt()).setRbh(rbhNetwork).build();
        FeeComponents feeMatricesForTxNode = FeeComponents.newBuilder().setConstant(1L).setBpt(feeComponents.getBpt()).setVpt((long)payerVpt).setBpr(feeComponents.getBpr()).setSbpr(feeComponents.getSbpr()).build();
        return FeeData.newBuilder().setNetworkdata(feeMatricesForTxNetwork).setNodedata(feeMatricesForTxNode).setServicedata(feeMatricesForTxService).build();
    }

    public static FeeData getQueryFeeDataMatrices(FeeComponents feeComponents) {
        FeeComponents feeMatricesForTxService = FeeComponents.getDefaultInstance();
        FeeComponents feeMatricesForTxNetwork = FeeComponents.getDefaultInstance();
        FeeComponents feeMatricesForTxNode = FeeComponents.newBuilder().setConstant(1L).setBpt(feeComponents.getBpt()).setBpr(feeComponents.getBpr()).setSbpr(feeComponents.getSbpr()).build();
        return FeeData.newBuilder().setNetworkdata(feeMatricesForTxNetwork).setNodedata(feeMatricesForTxNode).setServicedata(feeMatricesForTxService).build();
    }

    public static long getDefaultRbhNetworkSize() {
        return 6480L;
    }

    public static int getBaseTransactionRecordSize(TransactionBody txBody) {
        int txRecordSize = 132;
        if (txBody.getMemo() != null) {
            txRecordSize += txBody.getMemoBytes().size();
        }
        if (txBody.hasCryptoTransfer()) {
            txRecordSize += txBody.getCryptoTransfer().getTransfers().getAccountAmountsCount() * 32;
        }
        return txRecordSize;
    }

    public static long getTxRecordUsageRbh(TransactionRecord txRecord, int timeInSeconds) {
        if (txRecord == null) {
            return 0L;
        }
        long txRecordSize = FeeBuilder.getTransactionRecordSize(txRecord);
        return txRecordSize * (long)FeeBuilder.getHoursFromSec(timeInSeconds);
    }

    public static int getHoursFromSec(int valueInSeconds) {
        return valueInSeconds == 0 ? 0 : Math.max(1, valueInSeconds / 3600);
    }

    public static int getTransactionRecordSize(TransactionRecord txRecord) {
        if (txRecord == null) {
            return 0;
        }
        int txRecordSize = 132;
        if (txRecord.hasContractCallResult()) {
            txRecordSize += FeeBuilder.getContractFunctionSize(txRecord.getContractCallResult());
        } else if (txRecord.hasContractCreateResult()) {
            txRecordSize += FeeBuilder.getContractFunctionSize(txRecord.getContractCreateResult());
        }
        if (txRecord.hasTransferList()) {
            txRecordSize += txRecord.getTransferList().getAccountAmountsCount() * 32;
        }
        int memoBytesSize = 0;
        if (txRecord.getMemo() != null) {
            memoBytesSize = txRecord.getMemoBytes().size();
        }
        return txRecordSize + memoBytesSize;
    }

    public static int getContractFunctionSize(ContractFunctionResult contFuncResult) {
        int contResult = 0;
        if (contFuncResult.getContractCallResult() != null) {
            contResult = contFuncResult.getContractCallResult().size();
        }
        if (contFuncResult.getErrorMessage() != null) {
            contResult += contFuncResult.getErrorMessageBytes().size();
        }
        if (contFuncResult.getBloom() != null) {
            contResult += contFuncResult.getBloom().size();
        }
        contResult = contResult + 8 + 16;
        return contResult;
    }

    public static int getStateProofSize(ResponseType responseType) {
        return responseType == ResponseType.ANSWER_STATE_PROOF || responseType == ResponseType.COST_ANSWER_STATE_PROOF ? 2000 : 0;
    }

    protected static long calculateRbs(TransactionBody txBody) {
        return (long)FeeBuilder.getBaseTransactionRecordSize(txBody) * 180L;
    }

    protected static long calculateBpt() {
        return 236L;
    }
}

