/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.tls;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Optional;
import javax.security.auth.x500.X500Principal;

public class TlsUtils {
    private TlsUtils() {
    }

    public static Optional<String> parseCn(Certificate[] certificates) {
        if (certificates.length >= 1) {
            Certificate certificate = certificates[0];
            X509Certificate cert = (X509Certificate)certificate;
            X500Principal principal = cert.getSubjectX500Principal();
            int i = 0;
            String[] segments = principal.getName().split("=|,");
            while (i + 1 < segments.length) {
                if ("CN".equals(segments[i])) {
                    return Optional.of(segments[i + 1]);
                }
                i += 2;
            }
            return Optional.of("Unknown CN");
        }
        return Optional.empty();
    }
}

