/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.AnnotationSupport;
import io.helidon.common.types.TypeName;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

@Prototype.Blueprint
@Prototype.CustomMethods(value=AnnotationSupport.class)
@Prototype.Implement(value={"java.lang.Comparable<Annotation>"})
interface AnnotationBlueprint {
    public static final String VALUE_PROPERTY = "value";

    @Option.Required
    public TypeName typeName();

    @Option.Singular
    public Map<String, Object> values();

    @Option.Redundant
    @Option.Singular
    public List<Annotation> metaAnnotations();

    default public Optional<String> value() {
        return this.getValue(VALUE_PROPERTY);
    }

    default public Optional<String> getValue(String property) {
        return AnnotationSupport.asString(this.typeName(), this.values(), property);
    }

    default public Optional<Object> objectValue() {
        return this.objectValue(VALUE_PROPERTY);
    }

    default public Optional<Object> objectValue(String property) {
        return Optional.ofNullable(this.values().get(property));
    }

    default public Optional<String> stringValue() {
        return this.value();
    }

    default public Optional<String> stringValue(String property) {
        return this.getValue(property);
    }

    default public Optional<List<String>> stringValues() {
        return this.stringValues(VALUE_PROPERTY);
    }

    default public Optional<List<String>> stringValues(String property) {
        return AnnotationSupport.asStrings(this.typeName(), this.values(), property);
    }

    default public Optional<Integer> intValue() {
        return this.intValue(VALUE_PROPERTY);
    }

    default public Optional<Integer> intValue(String property) {
        return AnnotationSupport.asInt(this.typeName(), this.values(), property);
    }

    default public Optional<List<Integer>> intValues() {
        return this.intValues(VALUE_PROPERTY);
    }

    default public Optional<List<Integer>> intValues(String property) {
        return AnnotationSupport.asInts(this.typeName(), this.values(), property);
    }

    default public Optional<Long> longValue() {
        return this.longValue(VALUE_PROPERTY);
    }

    default public Optional<Long> longValue(String property) {
        return AnnotationSupport.asLong(this.typeName(), this.values(), property);
    }

    default public Optional<List<Long>> longValues() {
        return this.longValues(VALUE_PROPERTY);
    }

    default public Optional<List<Long>> longValues(String property) {
        return AnnotationSupport.asLongs(this.typeName(), this.values(), property);
    }

    default public Optional<Boolean> booleanValue() {
        return this.booleanValue(VALUE_PROPERTY);
    }

    default public Optional<Boolean> booleanValue(String property) {
        return AnnotationSupport.asBoolean(this.typeName(), this.values(), property);
    }

    default public Optional<List<Boolean>> booleanValues() {
        return this.booleanValues(VALUE_PROPERTY);
    }

    default public Optional<List<Boolean>> booleanValues(String property) {
        return AnnotationSupport.asBooleans(this.typeName(), this.values(), property);
    }

    default public Optional<Byte> byteValue() {
        return this.byteValue(VALUE_PROPERTY);
    }

    default public Optional<Byte> byteValue(String property) {
        return AnnotationSupport.asByte(this.typeName(), this.values(), property);
    }

    default public Optional<List<Byte>> byteValues() {
        return this.byteValues(VALUE_PROPERTY);
    }

    default public Optional<List<Byte>> byteValues(String property) {
        return AnnotationSupport.asBytes(this.typeName(), this.values(), property);
    }

    default public Optional<Character> charValue() {
        return this.charValue(VALUE_PROPERTY);
    }

    default public Optional<Character> charValue(String property) {
        return AnnotationSupport.asCharacter(this.typeName(), this.values(), property);
    }

    default public Optional<List<Character>> charValues() {
        return this.charValues(VALUE_PROPERTY);
    }

    default public Optional<List<Character>> charValues(String property) {
        return AnnotationSupport.asCharacters(this.typeName(), this.values(), property);
    }

    default public Optional<Short> shortValue() {
        return this.shortValue(VALUE_PROPERTY);
    }

    default public Optional<Short> shortValue(String property) {
        return AnnotationSupport.asShort(this.typeName(), this.values(), property);
    }

    default public Optional<List<Short>> shortValues() {
        return this.shortValues(VALUE_PROPERTY);
    }

    default public Optional<List<Short>> shortValues(String property) {
        return AnnotationSupport.asShorts(this.typeName(), this.values(), property);
    }

    default public Optional<Float> floatValue() {
        return this.floatValue(VALUE_PROPERTY);
    }

    default public Optional<Float> floatValue(String property) {
        return AnnotationSupport.asFloat(this.typeName(), this.values(), property);
    }

    default public Optional<List<Float>> floatValues() {
        return this.floatValues(VALUE_PROPERTY);
    }

    default public Optional<List<Float>> floatValues(String property) {
        return AnnotationSupport.asFloats(this.typeName(), this.values(), property);
    }

    default public Optional<Double> doubleValue() {
        return this.doubleValue(VALUE_PROPERTY);
    }

    default public Optional<Double> doubleValue(String property) {
        return AnnotationSupport.asDouble(this.typeName(), this.values(), property);
    }

    default public Optional<List<Double>> doubleValues() {
        return this.doubleValues(VALUE_PROPERTY);
    }

    default public Optional<List<Double>> doubleValues(String property) {
        return AnnotationSupport.asDoubles(this.typeName(), this.values(), property);
    }

    default public Optional<Class<?>> classValue() {
        return this.classValue(VALUE_PROPERTY);
    }

    default public Optional<Class<?>> classValue(String property) {
        return AnnotationSupport.asClass(this.typeName(), this.values(), property);
    }

    default public Optional<List<Class<?>>> classValues() {
        return this.classValues(VALUE_PROPERTY);
    }

    default public Optional<List<Class<?>>> classValues(String property) {
        return AnnotationSupport.asClasses(this.typeName(), this.values(), property);
    }

    default public Optional<TypeName> typeValue() {
        return this.typeValue(VALUE_PROPERTY);
    }

    default public Optional<TypeName> typeValue(String property) {
        return AnnotationSupport.asTypeName(this.typeName(), this.values(), property);
    }

    default public Optional<List<TypeName>> typeValues() {
        return this.typeValues(VALUE_PROPERTY);
    }

    default public Optional<List<TypeName>> typeValues(String property) {
        return AnnotationSupport.asTypeNames(this.typeName(), this.values(), property);
    }

    default public Optional<Annotation> annotationValue() {
        return this.annotationValue(VALUE_PROPERTY);
    }

    default public Optional<Annotation> annotationValue(String property) {
        return AnnotationSupport.asAnnotation(this.typeName(), this.values(), property);
    }

    default public Optional<List<Annotation>> annotationValues() {
        return this.annotationValues(VALUE_PROPERTY);
    }

    default public Optional<List<Annotation>> annotationValues(String property) {
        return AnnotationSupport.asAnnotations(this.typeName(), this.values(), property);
    }

    default public <T extends Enum<T>> Optional<T> enumValue(Class<T> type) {
        return this.enumValue(VALUE_PROPERTY, type);
    }

    default public <T extends Enum<T>> Optional<T> enumValue(String property, Class<T> type) {
        return AnnotationSupport.asEnum(this.typeName(), this.values(), property, type);
    }

    default public <T extends Enum<T>> Optional<List<T>> enumValues(Class<T> type) {
        return this.enumValues(VALUE_PROPERTY, type);
    }

    default public <T extends Enum<T>> Optional<List<T>> enumValues(String property, Class<T> type) {
        return AnnotationSupport.asEnums(this.typeName(), this.values(), property, type);
    }

    default public boolean hasMetaAnnotation(TypeName annotationType) {
        return this.metaAnnotations().stream().map(AnnotationBlueprint::typeName).anyMatch((Predicate<TypeName>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lio/helidon/common/types/TypeName;)Z)((TypeName)annotationType));
    }
}

