/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.setunlimitedautoassociations;

import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.token.CryptoUpdateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.HasCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.setunlimitedautoassociations.SetUnlimitedAutoAssociationsCall;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.config.data.ContractsConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SetUnlimitedAutoAssociationsTranslator
extends AbstractCallTranslator<HasCallAttempt> {
    public static final SystemContractMethod SET_UNLIMITED_AUTO_ASSOC = SystemContractMethod.declare("setUnlimitedAutomaticAssociations(bool)", "(int64)").withCategories(SystemContractMethod.Category.ASSOCIATION);
    private static final int UNLIMITED_AUTO_ASSOCIATIONS = -1;
    private static final int NO_AUTO_ASSOCIATIONS = 0;

    @Inject
    public SetUnlimitedAutoAssociationsTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HAS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(SET_UNLIMITED_AUTO_ASSOC);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HasCallAttempt attempt) {
        boolean setUnlimitedAutoAssocEnabled = ((ContractsConfig)attempt.configuration().getConfigData(ContractsConfig.class)).systemContractSetUnlimitedAutoAssociationsEnabled();
        if (attempt.isSelectorIfConfigEnabled(setUnlimitedAutoAssocEnabled, SET_UNLIMITED_AUTO_ASSOC)) {
            return Optional.of(SET_UNLIMITED_AUTO_ASSOC);
        }
        return Optional.empty();
    }

    @Override
    public Call callFrom(@NonNull HasCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        Tuple call = SET_UNLIMITED_AUTO_ASSOC.decodeCall(attempt.inputBytes());
        boolean setUnlimitedAutoAssociations = (Boolean)call.get(0);
        return new SetUnlimitedAutoAssociationsCall(attempt, this.bodyFor(attempt, setUnlimitedAutoAssociations));
    }

    @NonNull
    private TransactionBody bodyFor(@NonNull HasCallAttempt attempt, boolean setUnlimitedAutoAssociations) {
        CryptoUpdateTransactionBody cryptoUpdate = CryptoUpdateTransactionBody.newBuilder().accountIDToUpdate(attempt.redirectAccountId()).maxAutomaticTokenAssociations(Integer.valueOf(setUnlimitedAutoAssociations ? -1 : 0)).build();
        return TransactionBody.newBuilder().cryptoUpdateAccount(cryptoUpdate).build();
    }
}

