/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import java.security.SecureRandom;
import java.util.Random;
import org.apache.tuweni.bytes.ArrayWrappingBytes48;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.BytesValues;
import org.apache.tuweni.bytes.Checks;
import org.apache.tuweni.bytes.DelegatingBytes48;
import org.apache.tuweni.bytes.MutableBytes48;

public interface Bytes48
extends Bytes {
    public static final int SIZE = 48;
    public static final Bytes48 ZERO = Bytes48.wrap(new byte[48]);

    public static Bytes48 wrap(byte[] bytes) {
        Checks.checkNotNull(bytes);
        Checks.checkArgument(bytes.length == 48, "Expected %s bytes but got %s", 48, bytes.length);
        return Bytes48.wrap(bytes, 0);
    }

    public static Bytes48 wrap(byte[] bytes, int offset) {
        Checks.checkNotNull(bytes);
        return new ArrayWrappingBytes48(bytes, offset);
    }

    public static Bytes48 wrap(Bytes value) {
        Checks.checkNotNull(value);
        if (value instanceof Bytes48) {
            return (Bytes48)value;
        }
        Checks.checkArgument(value.size() == 48, "Expected %s bytes but got %s", 48, value.size());
        return new DelegatingBytes48(value);
    }

    public static Bytes48 wrap(Bytes value, int offset) {
        Checks.checkNotNull(value);
        if (value instanceof Bytes48) {
            return (Bytes48)value;
        }
        Bytes slice = value.slice(offset, 48);
        if (slice instanceof Bytes48) {
            return (Bytes48)slice;
        }
        return new DelegatingBytes48(Bytes48.wrap(slice));
    }

    public static Bytes48 leftPad(Bytes value) {
        Checks.checkNotNull(value);
        if (value instanceof Bytes48) {
            return (Bytes48)value;
        }
        Checks.checkArgument(value.size() <= 48, "Expected at most %s bytes but got %s", 48, value.size());
        MutableBytes48 result = MutableBytes48.create();
        value.copyTo(result, 48 - value.size());
        return result;
    }

    public static Bytes48 rightPad(Bytes value) {
        Checks.checkNotNull(value);
        if (value instanceof Bytes48) {
            return (Bytes48)value;
        }
        Checks.checkArgument(value.size() <= 48, "Expected at most %s bytes but got %s", 48, value.size());
        MutableBytes48 result = MutableBytes48.create();
        value.copyTo(result, 0);
        return result;
    }

    public static Bytes48 fromHexStringLenient(CharSequence str) {
        Checks.checkNotNull(str);
        return Bytes48.wrap(BytesValues.fromRawHexString(str, 48, true));
    }

    public static Bytes48 fromHexString(CharSequence str) {
        Checks.checkNotNull(str);
        return Bytes48.wrap(BytesValues.fromRawHexString(str, 48, false));
    }

    public static Bytes48 random() {
        return Bytes48.random(new SecureRandom());
    }

    public static Bytes48 random(Random generator) {
        byte[] array = new byte[48];
        generator.nextBytes(array);
        return Bytes48.wrap(array);
    }

    public static Bytes48 fromHexStringStrict(CharSequence str) {
        Checks.checkNotNull(str);
        return Bytes48.wrap(BytesValues.fromRawHexString(str, -1, false));
    }

    @Override
    default public int size() {
        return 48;
    }

    default public Bytes48 and(Bytes48 other) {
        return this.and(other, MutableBytes48.create());
    }

    default public Bytes48 or(Bytes48 other) {
        return this.or(other, MutableBytes48.create());
    }

    default public Bytes48 xor(Bytes48 other) {
        return this.xor(other, MutableBytes48.create());
    }

    @Override
    default public Bytes48 not() {
        return this.not(MutableBytes48.create());
    }

    @Override
    default public Bytes48 shiftRight(int distance) {
        return this.shiftRight(distance, MutableBytes48.create());
    }

    @Override
    default public Bytes48 shiftLeft(int distance) {
        return this.shiftLeft(distance, MutableBytes48.create());
    }

    @Override
    public Bytes48 copy();

    @Override
    public MutableBytes48 mutableCopy();
}

