/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl.streaming;

import com.hedera.hapi.block.stream.BlockItem;
import com.hedera.node.app.blocks.BlockItemWriter;
import com.hedera.node.app.blocks.impl.streaming.BlockBufferService;
import com.hedera.node.app.blocks.impl.streaming.BlockNodeConnectionManager;
import com.hedera.node.app.blocks.impl.streaming.FileBlockItemWriter;
import com.hedera.node.app.blocks.impl.streaming.GrpcBlockItemWriter;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.internal.network.PendingProof;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.file.FileSystem;
import java.util.Objects;

public class FileAndGrpcBlockItemWriter
implements BlockItemWriter {
    private final FileBlockItemWriter fileBlockItemWriter;
    private final GrpcBlockItemWriter grpcBlockItemWriter;

    public FileAndGrpcBlockItemWriter(@NonNull ConfigProvider configProvider, @NonNull NodeInfo nodeInfo, @NonNull FileSystem fileSystem, @NonNull BlockBufferService blockBufferService, @NonNull BlockNodeConnectionManager blockNodeConnectionManager) {
        this.fileBlockItemWriter = new FileBlockItemWriter(configProvider, nodeInfo, fileSystem);
        this.grpcBlockItemWriter = new GrpcBlockItemWriter(blockBufferService, blockNodeConnectionManager);
    }

    @Override
    public void openBlock(long blockNumber) {
        this.fileBlockItemWriter.openBlock(blockNumber);
        this.grpcBlockItemWriter.openBlock(blockNumber);
    }

    @Override
    public void writePbjItemAndBytes(@NonNull BlockItem item, @NonNull Bytes bytes) {
        Objects.requireNonNull(item, "item cannot be null");
        Objects.requireNonNull(bytes, "bytes cannot be null");
        this.fileBlockItemWriter.writeItem(bytes.toByteArray());
        this.grpcBlockItemWriter.writePbjItem(item);
    }

    @Override
    public void closeCompleteBlock() {
        this.fileBlockItemWriter.closeCompleteBlock();
        this.grpcBlockItemWriter.closeCompleteBlock();
    }

    @Override
    public void flushPendingBlock(@NonNull PendingProof pendingProof) {
        Objects.requireNonNull(pendingProof);
        this.fileBlockItemWriter.flushPendingBlock(pendingProof);
        this.grpcBlockItemWriter.flushPendingBlock(pendingProof);
    }

    @Override
    public void writePbjItem(@NonNull BlockItem item) {
        throw new UnsupportedOperationException("writePbjItem is not supported in this implementation");
    }

    @Override
    public void jumpToBlockAfterFreeze(long blockNumber) {
        this.grpcBlockItemWriter.jumpToBlockAfterFreeze(blockNumber);
    }
}

