/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.throttle;

import com.hedera.node.app.hapi.utils.sysfiles.domain.throttling.ScaleFactor;
import com.hedera.node.app.hapi.utils.throttles.BucketThrottle;
import com.hedera.node.app.hapi.utils.throttles.DeterministicThrottle;
import com.hedera.node.app.throttle.DeterministicThrottleUsage;
import com.hedera.node.app.throttle.ThrottleUsage;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class ThrottleReqsManager {
    private final boolean[] passedReq;
    private final List<Pair<DeterministicThrottle, Integer>> allReqs;

    public ThrottleReqsManager(List<Pair<DeterministicThrottle, Integer>> allReqs) {
        this.allReqs = allReqs;
        this.passedReq = new boolean[allReqs.size()];
    }

    public boolean allReqsMetAt(Instant now, @Nullable List<ThrottleUsage> throttleUsages) {
        return this.allVerboseReqsMetAt(now, 0, null, throttleUsages);
    }

    public boolean allReqsMetAt(Instant now, int nTransactions, ScaleFactor scaleFactor, @Nullable List<ThrottleUsage> throttleUsages) {
        return this.allVerboseReqsMetAt(now, nTransactions, scaleFactor, throttleUsages);
    }

    public void undoClaimedReqsFor(int nTransactions) {
        for (int i = 0; i < this.passedReq.length; ++i) {
            Pair<DeterministicThrottle, Integer> req = this.allReqs.get(i);
            Integer opsRequired = (Integer)req.getRight();
            DeterministicThrottle bucket = (DeterministicThrottle)req.getLeft();
            bucket.leakCapacity((long)(nTransactions * opsRequired) * BucketThrottle.capacityUnitsPerTxn());
        }
    }

    private boolean allVerboseReqsMetAt(Instant now, int nTransactions, ScaleFactor scaleFactor, @Nullable List<ThrottleUsage> throttleUsages) {
        boolean allPassed = true;
        for (int i = 0; i < this.passedReq.length; ++i) {
            Pair<DeterministicThrottle, Integer> req = this.allReqs.get(i);
            Integer opsRequired = (Integer)req.getRight();
            if (scaleFactor != null) {
                opsRequired = scaleFactor.scaling(nTransactions * opsRequired);
            }
            this.passedReq[i] = ((DeterministicThrottle)req.getLeft()).allow(opsRequired.intValue(), now);
            if (throttleUsages != null && this.passedReq[i]) {
                throttleUsages.add(new DeterministicThrottleUsage((DeterministicThrottle)req.getLeft(), opsRequired));
            }
            allPassed &= this.passedReq[i];
        }
        return allPassed;
    }

    public List<DeterministicThrottle> managedThrottles() {
        return this.allReqs.stream().map(Pair::getLeft).toList();
    }

    public String asReadableRequirements() {
        return "min{" + this.allReqs.stream().map(this::readable).collect(Collectors.joining(", ")) + "}";
    }

    private String readable(Pair<DeterministicThrottle, Integer> req) {
        DeterministicThrottle throttle = (DeterministicThrottle)req.getLeft();
        return this.approximateTps((Integer)req.getRight(), throttle.mtps()) + " tps (" + throttle.name() + ")";
    }

    private String approximateTps(int logicalTpsReq, long bucketMtps) {
        return String.format("%.2f", 1.0 * (double)bucketMtps / 1000.0 / (double)logicalTpsReq);
    }
}

