/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.hapi.util.UnknownHederaFunctionality;
import com.hedera.node.app.fees.ChildFeeContextImpl;
import com.hedera.node.app.fees.ExchangeRateManager;
import com.hedera.node.app.fees.FeeAccumulator;
import com.hedera.node.app.fees.FeeManager;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.signature.AppKeyVerifier;
import com.hedera.node.app.spi.authorization.Authorizer;
import com.hedera.node.app.spi.authorization.SystemPrivilege;
import com.hedera.node.app.spi.fees.ExchangeRateInfo;
import com.hedera.node.app.spi.fees.FeeCalculator;
import com.hedera.node.app.spi.fees.FeeCalculatorFactory;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.fees.ResourcePriceCalculator;
import com.hedera.node.app.spi.ids.EntityNumGenerator;
import com.hedera.node.app.spi.info.NetworkInfo;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.node.app.spi.key.KeyVerifier;
import com.hedera.node.app.spi.records.BlockRecordInfo;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.throttle.ThrottleAdviser;
import com.hedera.node.app.spi.validation.AttributeValidator;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.workflows.ComputeDispatchFeesAsTopLevel;
import com.hedera.node.app.spi.workflows.DispatchOptions;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.TransactionKeys;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.app.store.StoreFactoryImpl;
import com.hedera.node.app.workflows.InnerTransaction;
import com.hedera.node.app.workflows.TransactionChecker;
import com.hedera.node.app.workflows.TransactionInfo;
import com.hedera.node.app.workflows.dispatcher.TransactionDispatcher;
import com.hedera.node.app.workflows.handle.Dispatch;
import com.hedera.node.app.workflows.handle.DispatchProcessor;
import com.hedera.node.app.workflows.handle.dispatch.ChildDispatchFactory;
import com.hedera.node.app.workflows.handle.stack.SavepointStackImpl;
import com.hedera.node.app.workflows.handle.validation.AttributeValidatorImpl;
import com.hedera.node.app.workflows.handle.validation.ExpiryValidatorImpl;
import com.hedera.node.app.workflows.prehandle.PreHandleContextImpl;
import com.hedera.node.app.workflows.prehandle.PreHandleResult;
import com.hedera.node.app.workflows.prehandle.PreHandleWorkflow;
import com.hedera.node.app.workflows.purechecks.PureChecksContextImpl;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DispatchHandleContext
implements HandleContext,
FeeContext {
    private final Instant consensusNow;
    private final NodeInfo creatorInfo;
    private final TransactionInfo txnInfo;
    private final Configuration config;
    private final Authorizer authorizer;
    private final BlockRecordInfo blockRecordInfo;
    private final ResourcePriceCalculator resourcePriceCalculator;
    private final FeeManager feeManager;
    private final StoreFactoryImpl storeFactory;
    private final AccountID payerId;
    private final AppKeyVerifier verifier;
    private final HederaFunctionality topLevelFunction;
    private final Key payerKey;
    private final ExchangeRateManager exchangeRateManager;
    private final SavepointStackImpl stack;
    private final EntityNumGenerator entityNumGenerator;
    private final AttributeValidator attributeValidator;
    private final ExpiryValidator expiryValidator;
    private final TransactionDispatcher dispatcher;
    private final NetworkInfo networkInfo;
    private final ChildDispatchFactory childDispatchFactory;
    private final DispatchProcessor dispatchProcessor;
    private final ThrottleAdviser throttleAdviser;
    private final FeeAccumulator feeAccumulator;
    private Map<AccountID, Long> dispatchPaidRewards;
    private final HandleContext.DispatchMetadata dispatchMetaData;
    private final TransactionChecker transactionChecker;
    private final HandleContext.TransactionCategory transactionCategory;
    @Nullable
    private final List<PreHandleResult> preHandleResults;
    @Nullable
    private final PreHandleWorkflow preHandleWorkflow;

    public DispatchHandleContext(@NonNull Instant consensusNow, @NonNull NodeInfo creatorInfo, @NonNull TransactionInfo transactionInfo, @NonNull Configuration config, @NonNull Authorizer authorizer, @NonNull BlockRecordInfo blockRecordInfo, @NonNull ResourcePriceCalculator resourcePriceCalculator, @NonNull FeeManager feeManager, @NonNull StoreFactoryImpl storeFactory, @NonNull AccountID payerId, @NonNull AppKeyVerifier verifier, @NonNull HederaFunctionality topLevelFunction, @NonNull Key payerKey, @NonNull ExchangeRateManager exchangeRateManager, @NonNull SavepointStackImpl stack, @NonNull EntityNumGenerator entityNumGenerator, @NonNull TransactionDispatcher dispatcher, @NonNull NetworkInfo networkInfo, @NonNull ChildDispatchFactory childDispatchLogic, @NonNull DispatchProcessor dispatchProcessor, @NonNull ThrottleAdviser throttleAdviser, @NonNull FeeAccumulator feeAccumulator, @NonNull HandleContext.DispatchMetadata handleMetaData, @NonNull TransactionChecker transactionChecker, @Nullable List<PreHandleResult> preHandleResults, @Nullable PreHandleWorkflow preHandleWorkflow, @NonNull HandleContext.TransactionCategory transactionCategory) {
        this.consensusNow = Objects.requireNonNull(consensusNow);
        this.creatorInfo = Objects.requireNonNull(creatorInfo);
        this.txnInfo = Objects.requireNonNull(transactionInfo);
        this.config = Objects.requireNonNull(config);
        this.authorizer = Objects.requireNonNull(authorizer);
        this.blockRecordInfo = Objects.requireNonNull(blockRecordInfo);
        this.resourcePriceCalculator = Objects.requireNonNull(resourcePriceCalculator);
        this.feeManager = Objects.requireNonNull(feeManager);
        this.storeFactory = Objects.requireNonNull(storeFactory);
        this.payerId = Objects.requireNonNull(payerId);
        this.verifier = Objects.requireNonNull(verifier);
        this.topLevelFunction = Objects.requireNonNull(topLevelFunction);
        this.payerKey = Objects.requireNonNull(payerKey);
        this.exchangeRateManager = Objects.requireNonNull(exchangeRateManager);
        this.stack = Objects.requireNonNull(stack);
        this.entityNumGenerator = Objects.requireNonNull(entityNumGenerator);
        this.childDispatchFactory = Objects.requireNonNull(childDispatchLogic);
        this.dispatchProcessor = Objects.requireNonNull(dispatchProcessor);
        this.throttleAdviser = Objects.requireNonNull(throttleAdviser);
        this.feeAccumulator = Objects.requireNonNull(feeAccumulator);
        this.attributeValidator = new AttributeValidatorImpl(this);
        this.expiryValidator = new ExpiryValidatorImpl(this);
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.networkInfo = Objects.requireNonNull(networkInfo);
        this.dispatchMetaData = Objects.requireNonNull(handleMetaData);
        this.transactionChecker = Objects.requireNonNull(transactionChecker);
        this.transactionCategory = Objects.requireNonNull(transactionCategory);
        this.preHandleResults = preHandleResults;
        this.preHandleWorkflow = preHandleWorkflow;
    }

    @NonNull
    public Instant consensusNow() {
        return this.consensusNow;
    }

    @NonNull
    public TransactionBody body() {
        return this.txnInfo.txBody();
    }

    @NonNull
    public AccountID payer() {
        return this.payerId;
    }

    public boolean tryToCharge(@NonNull AccountID accountId, long amount) {
        Objects.requireNonNull(accountId);
        if (amount < 0L) {
            throw new IllegalArgumentException("Cannot charge negative amount " + amount);
        }
        return this.feeAccumulator.chargeFee(accountId, amount, null).networkFee() == amount;
    }

    public void refundBestEffort(@NonNull AccountID accountId, long amount) {
        Objects.requireNonNull(accountId);
        if (amount < 0L) {
            throw new IllegalArgumentException("Cannot charge negative amount " + amount);
        }
        this.feeAccumulator.refundFee(accountId, amount);
    }

    @NonNull
    public Configuration configuration() {
        return this.config;
    }

    @Nullable
    public Authorizer authorizer() {
        return this.authorizer;
    }

    public int numTxnSignatures() {
        return this.verifier.numSignaturesVerified();
    }

    public Fees dispatchComputeFees(@NonNull TransactionBody childTxBody, @NonNull AccountID syntheticPayerId) {
        Objects.requireNonNull(childTxBody);
        Objects.requireNonNull(syntheticPayerId);
        return this.dispatchComputeFees(childTxBody, syntheticPayerId, ComputeDispatchFeesAsTopLevel.NO);
    }

    @NonNull
    public BlockRecordInfo blockRecordInfo() {
        return this.blockRecordInfo;
    }

    @NonNull
    public ResourcePriceCalculator resourcePriceCalculator() {
        return this.resourcePriceCalculator;
    }

    @NonNull
    private FeeCalculator createFeeCalculator(@NonNull SubType subType) {
        return this.feeManager.createFeeCalculator(this.ensureTxnId(this.txnInfo.txBody()), this.payerKey, this.txnInfo.functionality(), this.numTxnSignatures(), SignatureMap.PROTOBUF.measureRecord((Object)this.txnInfo.signatureMap()), this.consensusNow, subType, false, this.storeFactory.asReadOnly());
    }

    @NonNull
    public FeeCalculatorFactory feeCalculatorFactory() {
        return this::createFeeCalculator;
    }

    @NonNull
    public ExchangeRateInfo exchangeRateInfo() {
        return this.exchangeRateManager.exchangeRateInfo(this.stack);
    }

    public EntityNumGenerator entityNumGenerator() {
        return this.entityNumGenerator;
    }

    @NonNull
    public AttributeValidator attributeValidator() {
        return this.attributeValidator;
    }

    @NonNull
    public ExpiryValidator expiryValidator() {
        return this.expiryValidator;
    }

    @NonNull
    public TransactionKeys allKeysForTransaction(@NonNull TransactionBody nestedTxn, @NonNull AccountID payerForNested) throws PreCheckException {
        PureChecksContextImpl nestedPureChecksContext = new PureChecksContextImpl(nestedTxn, this.dispatcher);
        this.dispatcher.dispatchPureChecks(nestedPureChecksContext);
        PreHandleContextImpl nestedContext = new PreHandleContextImpl(this.storeFactory.asReadOnly(), nestedTxn, payerForNested, this.configuration(), this.dispatcher, this.transactionChecker, this.creatorInfo);
        try {
            this.dispatcher.dispatchPreHandle(nestedContext);
        }
        catch (PreCheckException ignored) {
            throw new PreCheckException(ResponseCodeEnum.UNRESOLVABLE_REQUIRED_SIGNERS);
        }
        return nestedContext;
    }

    @NonNull
    public KeyVerifier keyVerifier() {
        return this.verifier;
    }

    public SystemPrivilege hasPrivilegedAuthorization() {
        return this.authorizer.hasPrivilegedAuthorization(this.payerId, this.txnInfo.functionality(), this.txnInfo.txBody());
    }

    @NonNull
    public <T> T readableStore(@NonNull Class<T> storeInterface) {
        Objects.requireNonNull(storeInterface, "storeInterface must not be null");
        return this.storeFactory.readableStore(storeInterface);
    }

    @NonNull
    public StoreFactory storeFactory() {
        return this.storeFactory;
    }

    @NonNull
    public NetworkInfo networkInfo() {
        return this.networkInfo;
    }

    public Fees dispatchComputeFees(@NonNull TransactionBody txBody, @NonNull AccountID syntheticPayerId, @NonNull ComputeDispatchFeesAsTopLevel computeDispatchFeesAsTopLevel) {
        TransactionBody bodyToDispatch = this.ensureTxnId(txBody);
        try {
            if (this.authorizer.hasWaivedFees(syntheticPayerId, HapiUtils.functionOf((TransactionBody)txBody), bodyToDispatch)) {
                return Fees.FREE;
            }
        }
        catch (UnknownHederaFunctionality ex) {
            throw new HandleException(ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        }
        int signatureMapSize = SignatureMap.PROTOBUF.measureRecord((Object)this.txnInfo.signatureMap());
        return this.dispatcher.dispatchComputeFees(new ChildFeeContextImpl(this.feeManager, this, bodyToDispatch, syntheticPayerId, computeDispatchFeesAsTopLevel == ComputeDispatchFeesAsTopLevel.NO, this.authorizer, this.storeFactory.asReadOnly(), this.consensusNow, this.shouldChargeForSigVerification(txBody) ? this.verifier : null, this.shouldChargeForSigVerification(txBody) ? signatureMapSize : 0));
    }

    private boolean shouldChargeForSigVerification(@NonNull TransactionBody txBody) {
        return this.transactionCategory == HandleContext.TransactionCategory.BATCH_INNER && txBody.hasBatchKey();
    }

    @NonNull
    private TransactionBody ensureTxnId(@NonNull TransactionBody txBody) {
        if (!txBody.hasTransactionID()) {
            return txBody.copyBuilder().transactionID(TransactionID.newBuilder().accountID(this.payerId).transactionValidStart(Timestamp.newBuilder().seconds(this.consensusNow().getEpochSecond()).nanos(this.consensusNow().getNano()))).build();
        }
        return txBody;
    }

    public <T extends StreamBuilder> T dispatch(@NonNull DispatchOptions<T> options) {
        List paidStakingRewards;
        Objects.requireNonNull(options);
        PreHandleResult childPreHandleResult = null;
        if (options.category() == HandleContext.TransactionCategory.BATCH_INNER) {
            PreHandleResult maybeReusablePreHandleResult = this.preHandleResults != null && !this.preHandleResults.isEmpty() ? this.preHandleResults.removeFirst() : null;
            Bytes batchInnerTxnBytes = (Bytes)options.dispatchMetadata().getMetadata(HandleContext.DispatchMetadata.Type.INNER_TRANSACTION_BYTES, Bytes.class).orElseThrow();
            childPreHandleResult = this.preHandleWorkflow.preHandleTransaction(this.creatorInfo, this.storeFactory.asReadOnly(), this.storeFactory.readableStore(ReadableAccountStore.class), batchInnerTxnBytes, maybeReusablePreHandleResult, s -> {}, InnerTransaction.YES);
        }
        Dispatch childDispatch = this.childDispatchFactory.createChildDispatch(this.config, this.stack, this.storeFactory.asReadOnly(), this.creatorInfo, this.topLevelFunction, this.throttleAdviser, this.consensusNow, this.blockRecordInfo, options, childPreHandleResult);
        this.dispatchProcessor.processDispatch(childDispatch);
        if (options.commitImmediately()) {
            this.stack.commitTransaction(childDispatch.streamBuilder());
        }
        if (!(paidStakingRewards = childDispatch.streamBuilder().getPaidStakingRewards()).isEmpty()) {
            if (this.dispatchPaidRewards == null) {
                this.dispatchPaidRewards = new LinkedHashMap<AccountID, Long>();
            }
            paidStakingRewards.forEach(aa -> this.dispatchPaidRewards.put(aa.accountIDOrThrow(), aa.amount()));
        }
        return (T)((StreamBuilder)SavepointStackImpl.castBuilder(childDispatch.streamBuilder(), options.streamBuilderType()));
    }

    @NonNull
    public HandleContext.SavepointStack savepointStack() {
        return this.stack;
    }

    @NonNull
    public ThrottleAdviser throttleAdviser() {
        return this.throttleAdviser;
    }

    @NonNull
    public Map<AccountID, Long> dispatchPaidRewards() {
        return this.dispatchPaidRewards == null ? Collections.emptyMap() : this.dispatchPaidRewards;
    }

    public NodeInfo creatorInfo() {
        return this.creatorInfo;
    }

    @NonNull
    public HandleContext.DispatchMetadata dispatchMetadata() {
        return this.dispatchMetaData;
    }
}

