/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class JumpOperation
extends AbstractFixedCostOperation {
    private static final Operation.OperationResult invalidJumpResponse = new Operation.OperationResult(8L, ExceptionalHaltReason.INVALID_JUMP_DESTINATION);
    private static final Operation.OperationResult jumpResponse = new Operation.OperationResult(8L, null, 0);

    public JumpOperation(GasCalculator gasCalculator) {
        super(86, "JUMP", 2, 0, gasCalculator, gasCalculator.getMidTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        return JumpOperation.staticOperation(frame);
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame) {
        int jumpDestination;
        Bytes bytes = frame.popStackItem().trimLeadingZeros();
        try {
            jumpDestination = bytes.toInt();
        }
        catch (RuntimeException iae) {
            return invalidJumpResponse;
        }
        Code code = frame.getCode();
        if (code.isJumpDestInvalid(jumpDestination)) {
            return invalidJumpResponse;
        }
        frame.setPC(jumpDestination);
        return jumpResponse;
    }
}

