/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http2;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.webserver.ProtocolConfigs;
import io.helidon.webserver.http1.spi.Http1UpgradeProvider;
import io.helidon.webserver.http1.spi.Http1Upgrader;
import io.helidon.webserver.http2.Http2Config;
import io.helidon.webserver.http2.Http2Upgrader;
import io.helidon.webserver.http2.spi.Http2SubProtocolProvider;
import io.helidon.webserver.http2.spi.Http2SubProtocolSelector;
import io.helidon.webserver.spi.ProtocolConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public class Http2UpgradeProvider
implements Http1UpgradeProvider<Http2Config> {
    private final Http2Config http2Config;
    private final List<Http2SubProtocolProvider> subProtocolProviders;

    private Http2UpgradeProvider(Builder builder) {
        this.http2Config = builder.http2Config;
        this.subProtocolProviders = builder.subProtocolProviders.build().asList();
    }

    public Http2UpgradeProvider() {
        this(Http2UpgradeProvider.builder());
    }

    public static Builder builder() {
        return new Builder();
    }

    public String protocolType() {
        return "http_2";
    }

    public Class<Http2Config> protocolConfigType() {
        return Http2Config.class;
    }

    public Http1Upgrader create(Http2Config config, ProtocolConfigs configs) {
        Http2Config usedConfig = this.http2Config == null ? config : this.http2Config;
        ArrayList<Http2SubProtocolSelector> subProtocolSelectors = new ArrayList<Http2SubProtocolSelector>();
        for (Http2SubProtocolProvider subProtocolProvider : this.subProtocolProviders) {
            List providerConfigs = configs.config(subProtocolProvider.protocolType(), subProtocolProvider.protocolConfigType());
            for (ProtocolConfig providerConfig : providerConfigs) {
                subProtocolSelectors.add(subProtocolProvider.create(providerConfig, configs));
            }
        }
        return new Http2Upgrader(usedConfig, subProtocolSelectors);
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, Http2UpgradeProvider> {
        private final HelidonServiceLoader.Builder<Http2SubProtocolProvider> subProtocolProviders = HelidonServiceLoader.builder(ServiceLoader.load(Http2SubProtocolProvider.class));
        private Http2Config http2Config;

        private Builder() {
        }

        public Http2UpgradeProvider build() {
            return new Http2UpgradeProvider(this);
        }

        public Builder http2Config(Http2Config http2Config) {
            this.http2Config = http2Config;
            return this;
        }

        public Builder addSubProtocolProvider(Http2SubProtocolProvider provider) {
            this.subProtocolProviders.addService((Object)provider);
            return this;
        }
    }
}

