/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.webserver.http.ErrorHandler;
import io.helidon.webserver.http.Filter;
import io.helidon.webserver.http.HttpRoute;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.HttpSecurity;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.http.Registration;

class Registrations {
    Registrations() {
    }

    static final class SecurityRegistration
    implements Registration {
        private final HttpSecurity security;

        SecurityRegistration(HttpSecurity security) {
            this.security = security;
        }

        @Override
        public void register(HttpRouting.Builder routing) {
            routing.security(this.security);
        }
    }

    static final class MaxRerouteCountRegistration
    implements Registration {
        private final int maxReRouteCount;

        MaxRerouteCountRegistration(int maxReRouteCount) {
            this.maxReRouteCount = maxReRouteCount;
        }

        @Override
        public void register(HttpRouting.Builder routing) {
            routing.maxReRouteCount(this.maxReRouteCount);
        }
    }

    static final class FilterRegistration
    implements Registration {
        private final Filter filter;

        FilterRegistration(Filter filter) {
            this.filter = filter;
        }

        @Override
        public void register(HttpRouting.Builder routing) {
            routing.addFilter(this.filter);
        }
    }

    static final class RouteRegistration
    implements Registration {
        private final HttpRoute route;

        RouteRegistration(HttpRoute route) {
            this.route = route;
        }

        @Override
        public void register(HttpRouting.Builder routing) {
            routing.route(this.route);
        }
    }

    static final class ErrorRegistration<T>
    implements Registration {
        private final Class exceptionClass;
        private final ErrorHandler handler;

        ErrorRegistration(Class<T> exceptionClass, ErrorHandler<? super T> handler) {
            this.exceptionClass = exceptionClass;
            this.handler = handler;
        }

        @Override
        public void register(HttpRouting.Builder routing) {
            routing.error(this.exceptionClass, this.handler);
        }
    }

    static final class ServiceRegistration
    implements Registration {
        private final HttpService[] service;

        ServiceRegistration(HttpService ... service) {
            this.service = service;
        }

        @Override
        public void register(HttpRouting.Builder routing) {
            routing.register(this.service);
        }
    }

    static final class ServicePathRegistration
    implements Registration {
        private final HttpService[] service;
        private final String path;

        ServicePathRegistration(String path, HttpService ... service) {
            this.path = path;
            this.service = service;
        }

        @Override
        public void register(HttpRouting.Builder routing) {
            routing.register(this.path, this.service);
        }
    }
}

