/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Transaction;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.transaction.ExchangeRateSet;
import com.hedera.hapi.node.transaction.SignedTransaction;
import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;

public interface TranslationContext {
    public String memo();

    public ExchangeRateSet transactionExchangeRates();

    public TransactionID txnId();

    public SignedTransaction signedTx();

    public HederaFunctionality functionality();

    public Bytes serializedSignedTx();

    default public Bytes transactionHash() {
        SignedTransaction signedTx = this.signedTx();
        if (signedTx.useSerializedTxMessageHashAlgorithm()) {
            Transaction tx = Transaction.newBuilder().bodyBytes(signedTx.bodyBytes()).sigMap(signedTx.sigMap()).build();
            Bytes bytes = Transaction.PROTOBUF.toBytes((Object)tx);
            return Bytes.wrap((byte[])CommonUtils.noThrowSha384HashOf((byte[])bytes.toByteArray()));
        }
        Bytes bytes = this.serializedSignedTx();
        if (bytes == null) {
            bytes = SignedTransaction.PROTOBUF.toBytes((Object)signedTx);
        }
        return Bytes.wrap((byte[])CommonUtils.noThrowSha384HashOf((byte[])bytes.toByteArray()));
    }
}

