/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.disk;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.merkle.disk.BackedOnDiskIterator;
import com.swirlds.state.merkle.logging.StateLogger;
import com.swirlds.state.spi.WritableKVStateBase;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.Objects;

@Deprecated
public final class BackedWritableKVState<K, V>
extends WritableKVStateBase<K, V> {
    private final VirtualMap virtualMap;
    @NonNull
    private final Codec<K> keyCodec;
    @NonNull
    private final Codec<V> valueCodec;

    public BackedWritableKVState(@NonNull String serviceName, @NonNull String stateKey, @NonNull Codec<K> keyCodec, @NonNull Codec<V> valueCodec, @NonNull VirtualMap virtualMap) {
        super(serviceName, stateKey);
        this.keyCodec = Objects.requireNonNull(keyCodec);
        this.valueCodec = Objects.requireNonNull(valueCodec);
        this.virtualMap = Objects.requireNonNull(virtualMap);
    }

    protected V readFromDataSource(@NonNull K key) {
        Bytes kb = this.keyCodec.toBytes(key);
        Object value = this.virtualMap.get(kb, this.valueCodec);
        StateLogger.logMapGet(this.getStateKey(), key, value);
        return (V)value;
    }

    @NonNull
    protected Iterator<K> iterateFromDataSource() {
        StateLogger.logMapIterate(this.getStateKey(), this.virtualMap, this.keyCodec);
        return new BackedOnDiskIterator(this.virtualMap, this.keyCodec);
    }

    protected void putIntoDataSource(@NonNull K key, @NonNull V value) {
        Bytes kb = this.keyCodec.toBytes(key);
        assert (kb != null);
        this.virtualMap.put(kb, value, this.valueCodec);
        StateLogger.logMapPut(this.getStateKey(), key, value);
    }

    protected void removeFromDataSource(@NonNull K key) {
        Bytes k = this.keyCodec.toBytes(key);
        Object removed = this.virtualMap.remove(k, this.valueCodec);
        StateLogger.logMapRemove(this.getStateKey(), key, removed);
    }

    public long sizeOfDataSource() {
        long size = this.virtualMap.size();
        StateLogger.logMapGetSize(this.getStateKey(), size);
        return size;
    }
}

