/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.spi;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.spi.fees.FeeCharging;
import com.hedera.node.app.spi.ids.EntityIdFactory;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.node.app.spi.signatures.SignatureVerifier;
import com.hedera.node.app.spi.throttle.Throttle;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.time.InstantSource;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Signature;

public interface AppContext {
    public static final Logger log = LogManager.getLogger(AppContext.class);

    public InstantSource instantSource();

    public SignatureVerifier signatureVerifier();

    public Gossip gossip();

    public Supplier<Configuration> configSupplier();

    public Supplier<NodeInfo> selfNodeInfoSupplier();

    public Supplier<Metrics> metricsSupplier();

    public Throttle.Factory throttleFactory();

    public Supplier<FeeCharging> feeChargingSupplier();

    public EntityIdFactory idFactory();

    public static interface Gossip {
        public static final int NANOS_TO_SKIP_ON_DUPLICATE = 13;
        public static final String DUPLICATE_TRANSACTION_REASON = String.valueOf(ResponseCodeEnum.DUPLICATE_TRANSACTION);
        public static final Gossip UNAVAILABLE_GOSSIP = new Gossip(){

            @Override
            public void submit(@NonNull TransactionBody body) {
                throw new IllegalStateException("Gossip is not available!");
            }

            @Override
            public Signature sign(byte[] ledgerId) {
                throw new IllegalStateException("Gossip is not available!");
            }

            @Override
            public boolean isAvailable() {
                return false;
            }
        };

        default public CompletableFuture<Void> submitFuture(@NonNull AccountID selfId, @NonNull Instant consensusNow, @NonNull java.time.Duration validDuration, @NonNull Consumer<TransactionBody.Builder> spec, @NonNull Executor executor, int timesToTry, int distinctTxnIdsPerTry, @NonNull java.time.Duration retryDelay, @NonNull BiConsumer<TransactionBody, String> onFailure) {
            AtomicInteger attemptsLeft = new AtomicInteger(timesToTry);
            AtomicReference<Instant> validStartTime = new AtomicReference<Instant>(consensusNow);
            Duration txnIdValidDuration = new Duration(validDuration.toSeconds());
            return CompletableFuture.runAsync(() -> {
                boolean fatalFailure = false;
                String failureReason = "<N/A>";
                do {
                    TransactionBody body;
                    int txnIdsLeft = distinctTxnIdsPerTry;
                    do {
                        TransactionBody.Builder builder = TransactionBody.newBuilder().nodeAccountID(selfId).transactionValidDuration(txnIdValidDuration).transactionID(new TransactionID(HapiUtils.asTimestamp((Instant)((Instant)validStartTime.get())), selfId, false, 0));
                        spec.accept(builder);
                        body = builder.build();
                        try {
                            this.submit(body);
                            return;
                        }
                        catch (IllegalArgumentException iae) {
                            failureReason = iae.getMessage();
                            if (DUPLICATE_TRANSACTION_REASON.equals(failureReason)) {
                                validStartTime.set(((Instant)validStartTime.get()).plusNanos(13L));
                                log.info("Retrying {} after duplicate transaction", (Object)body.data().kind());
                                continue;
                            }
                            fatalFailure = true;
                            break;
                        }
                        catch (IllegalStateException ise) {
                            failureReason = ise.getMessage();
                            break;
                        }
                    } while (txnIdsLeft-- > 1);
                    onFailure.accept(body, failureReason);
                    if (fatalFailure) continue;
                    log.info("Retrying {} after {}", (Object)body.data().kind(), (Object)failureReason);
                    try {
                        TimeUnit.MILLISECONDS.sleep(retryDelay.toMillis());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IllegalStateException("Interrupted while waiting to retry " + String.valueOf(body), e);
                    }
                } while (!fatalFailure && attemptsLeft.decrementAndGet() > 0);
                throw new IllegalStateException(failureReason);
            }, executor);
        }

        public void submit(@NonNull TransactionBody var1);

        public Signature sign(byte[] var1);

        public boolean isAvailable();
    }
}

