/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.transfer;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.node.app.service.token.impl.handlers.transfer.TransferContext;
import com.hedera.node.app.service.token.impl.handlers.transfer.TransferStep;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EnsureAliasesStep
implements TransferStep {
    private final CryptoTransferTransactionBody op;
    private final Map<Bytes, AccountID> tokenTransferResolutions = new LinkedHashMap<Bytes, AccountID>();

    public EnsureAliasesStep(@NonNull CryptoTransferTransactionBody op) {
        this.op = Objects.requireNonNull(op);
    }

    @Override
    public void doIn(@NonNull TransferContext transferContext) {
        Objects.requireNonNull(transferContext);
        List hbarTransfers = this.op.transfersOrElse(TransferList.DEFAULT).accountAmounts();
        List tokenTransfers = this.op.tokenTransfers();
        this.resolveHbarAdjusts(hbarTransfers, transferContext);
        this.resolveTokenAdjusts(tokenTransfers, transferContext);
    }

    private void resolveTokenAdjusts(@NonNull List<TokenTransferList> tokenTransfers, @NonNull TransferContext transferContext) {
        for (TokenTransferList tt : tokenTransfers) {
            this.tokenTransferResolutions.clear();
            for (AccountAmount adjust : tt.transfers()) {
                if (!EnsureAliasesStep.isAlias(adjust.accountIDOrThrow())) continue;
                AccountID account = this.resolveForFungibleToken(adjust, transferContext);
                Bytes alias = adjust.accountIDOrThrow().alias();
                this.tokenTransferResolutions.put(alias, account);
                HandleException.validateTrue((account != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
            }
            for (NftTransfer nftAdjust : tt.nftTransfers()) {
                this.resolveForNft(nftAdjust, transferContext);
            }
        }
    }

    private AccountID resolveForFungibleToken(@NonNull AccountAmount adjust, @NonNull TransferContext transferContext) {
        AccountID accountId = adjust.accountIDOrThrow();
        HandleException.validateFalse((boolean)this.tokenTransferResolutions.containsKey(accountId.alias()), (ResponseCodeEnum)ResponseCodeEnum.INVALID_ALIAS_KEY);
        AccountID account = transferContext.getFromAlias(accountId);
        if (account == null) {
            Bytes alias = accountId.alias();
            boolean isInResolutions = transferContext.resolutions().containsKey(alias);
            if (adjust.amount() > 0L && !isInResolutions) {
                transferContext.createFromAlias(alias, EnsureAliasesStep.impliedAutoAssociationsForAlias(accountId, this.op));
            } else {
                HandleException.validateTrue((boolean)transferContext.resolutions().containsKey(alias), (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
            }
            return transferContext.resolutions().get(alias);
        }
        return account;
    }

    private void resolveHbarAdjusts(@NonNull List<AccountAmount> hbarTransfers, @NonNull TransferContext transferContext) {
        for (AccountAmount aa : hbarTransfers) {
            AccountID accountId = aa.accountIDOrThrow();
            if (!EnsureAliasesStep.isAlias(accountId)) continue;
            boolean isInResolutions = transferContext.resolutions().containsKey(accountId.alias());
            HandleException.validateTrue((!isInResolutions ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_REPEATED_IN_ACCOUNT_AMOUNTS);
            AccountID account = transferContext.getFromAlias(accountId);
            if (aa.amount() > 0L) {
                if (account != null) continue;
                transferContext.createFromAlias(accountId.alias(), EnsureAliasesStep.impliedAutoAssociationsForAlias(accountId, this.op));
                continue;
            }
            HandleException.validateTrue((account != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
    }

    private void resolveForNft(@NonNull NftTransfer nftAdjust, @NonNull TransferContext transferContext) {
        AccountID receiverId = nftAdjust.receiverAccountIDOrThrow();
        AccountID senderId = nftAdjust.senderAccountIDOrThrow();
        if (EnsureAliasesStep.isAlias(senderId)) {
            AccountID sender = transferContext.getFromAlias(senderId);
            HandleException.validateTrue((sender != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
        if (EnsureAliasesStep.isAlias(receiverId)) {
            AccountID receiver = transferContext.getFromAlias(receiverId);
            if (receiver == null) {
                boolean isInResolutions = transferContext.resolutions().containsKey(receiverId.alias());
                if (!isInResolutions) {
                    transferContext.createFromAlias(receiverId.alias(), EnsureAliasesStep.impliedAutoAssociationsForAlias(receiverId, this.op));
                }
            } else {
                HandleException.validateTrue((receiver != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
            }
        }
    }

    public static boolean isAlias(@NonNull AccountID accountID) {
        Objects.requireNonNull(accountID);
        return accountID.hasAlias() && accountID.accountNumOrElse(Long.valueOf(0L)) == 0L;
    }

    public static int impliedAutoAssociationsForAlias(@NonNull AccountID aliasedReceiverId, @NonNull CryptoTransferTransactionBody op) {
        Objects.requireNonNull(op);
        Objects.requireNonNull(aliasedReceiverId);
        int ans = 0;
        for (TokenTransferList tokenTransferList : op.tokenTransfers()) {
            boolean impliedAutoAssociationHere = false;
            for (AccountAmount unitAdjust : tokenTransferList.transfers()) {
                if (unitAdjust.amount() <= 0L || !unitAdjust.accountIDOrThrow().equals((Object)aliasedReceiverId)) continue;
                impliedAutoAssociationHere = true;
                break;
            }
            for (NftTransfer nftTransfer : tokenTransferList.nftTransfers()) {
                if (!nftTransfer.receiverAccountIDOrThrow().equals((Object)aliasedReceiverId)) continue;
                impliedAutoAssociationHere = true;
                break;
            }
            if (!impliedAutoAssociationHere) continue;
            ++ans;
        }
        return ans;
    }
}

