/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.gascalculator;

import java.util.function.Supplier;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.ByzantiumGasCalculator;
import org.hyperledger.besu.evm.internal.Words;

public class ConstantinopleGasCalculator
extends ByzantiumGasCalculator {
    private static final long SSTORE_NO_OP_COST = 200L;
    private static final long SSTORE_ADDITIONAL_WRITE_COST = 200L;
    private static final long SSTORE_FIRST_DIRTY_NEW_STORAGE_COST = 20000L;
    private static final long SSTORE_FIRST_DIRTY_EXISTING_STORAGE_COST = 5000L;
    private static final long STORAGE_RESET_REFUND_AMOUNT = 15000L;
    private static final long NEGATIVE_STORAGE_RESET_REFUND_AMOUNT = -15000L;
    private static final long SSTORE_DIRTY_RETURN_TO_UNUSED_REFUND_AMOUNT = 19800L;
    private static final long SSTORE_DIRTY_RETURN_TO_ORIGINAL_VALUE_REFUND_AMOUNT = 4800L;
    private static final long EXTCODE_HASH_COST = 400L;

    @Override
    public long create2OperationGasCost(MessageFrame frame) {
        long initCodeLength = Words.clampedToLong(frame.getStackItem(2));
        long numWords = Words.clampedAdd(initCodeLength, 31L) / 32L;
        long initCodeHashCost = Words.clampedMultiply(6L, numWords);
        return Words.clampedAdd(this.createOperationGasCost(frame), initCodeHashCost);
    }

    @Override
    public long calculateStorageCost(UInt256 newValue, Supplier<UInt256> currentValue, Supplier<UInt256> originalValue) {
        UInt256 localCurrentValue = currentValue.get();
        if (localCurrentValue.equals((Object)newValue)) {
            return 200L;
        }
        UInt256 localOriginalValue = originalValue.get();
        if (localOriginalValue.equals((Object)localCurrentValue)) {
            return localOriginalValue.isZero() ? 20000L : 5000L;
        }
        return 200L;
    }

    @Override
    public long calculateStorageRefundAmount(UInt256 newValue, Supplier<UInt256> currentValue, Supplier<UInt256> originalValue) {
        UInt256 localCurrentValue = currentValue.get();
        if (localCurrentValue.equals((Object)newValue)) {
            return 0L;
        }
        UInt256 localOriginalValue = originalValue.get();
        if (localOriginalValue.equals((Object)localCurrentValue)) {
            if (localOriginalValue.isZero()) {
                return 0L;
            }
            if (newValue.isZero()) {
                return 15000L;
            }
            return 0L;
        }
        long refund = 0L;
        if (!localOriginalValue.isZero()) {
            if (localCurrentValue.isZero()) {
                refund = -15000L;
            } else if (newValue.isZero()) {
                refund = 15000L;
            }
        }
        if (localOriginalValue.equals((Object)newValue)) {
            refund += localOriginalValue.isZero() ? 19800L : 4800L;
        }
        return refund;
    }

    @Override
    public long extCodeHashOperationGasCost() {
        return 400L;
    }
}

