/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.operations;

import com.hedera.node.app.service.contract.impl.exec.AddressChecks;
import com.hedera.node.app.service.contract.impl.exec.FeatureFlags;
import com.hedera.node.app.service.contract.impl.exec.failure.CustomExceptionalHaltReason;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.exec.utils.OperationUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.UnderflowException;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.ExtCodeCopyOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class CustomExtCodeCopyOperation
extends ExtCodeCopyOperation {
    private static final Operation.OperationResult UNDERFLOW_RESPONSE = new Operation.OperationResult(0L, ExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS);
    private final AddressChecks addressChecks;
    private final FeatureFlags featureFlags;

    public CustomExtCodeCopyOperation(@NonNull GasCalculator gasCalculator, @NonNull AddressChecks addressChecks, @NonNull FeatureFlags featureFlags) {
        super(gasCalculator);
        this.addressChecks = addressChecks;
        this.featureFlags = featureFlags;
    }

    public Operation.OperationResult execute(@NonNull MessageFrame frame, @NonNull EVM evm) {
        try {
            Address address = Words.toAddress((Bytes)frame.getStackItem(0));
            long memOffset = Words.clampedToLong((Bytes)frame.getStackItem(1));
            long sourceOffset = Words.clampedToLong((Bytes)frame.getStackItem(2));
            long numBytes = Words.clampedToLong((Bytes)frame.getStackItem(3));
            long cost = this.cost(frame, memOffset, numBytes, false);
            if (OperationUtils.isDeficientGas(frame, cost)) {
                return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
            }
            if (this.addressChecks.isNonUserAccount(address)) {
                frame.writeMemory(memOffset, sourceOffset, numBytes, Bytes.EMPTY);
                frame.popStackItems(4);
                return new Operation.OperationResult(cost, null);
            }
            if (FrameUtils.contractRequired(frame, address, this.featureFlags) && !this.addressChecks.isPresent(address, frame)) {
                return new Operation.OperationResult(cost, (ExceptionalHaltReason)CustomExceptionalHaltReason.INVALID_SOLIDITY_ADDRESS);
            }
            return super.execute(frame, evm);
        }
        catch (UnderflowException ignore) {
            return UNDERFLOW_RESPONSE;
        }
    }
}

