/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp;

import com.esaulpaugh.headlong.rlp.DataType;
import com.esaulpaugh.headlong.rlp.RLPDecoder;
import com.esaulpaugh.headlong.rlp.RLPEncoder;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.esaulpaugh.headlong.util.FastHex;
import com.esaulpaugh.headlong.util.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class Notation {
    private static final RLPDecoder DECODER = RLPDecoder.RLP_LENIENT;
    private static final String BEGIN_NOTATION = "(";
    private static final String END_NOTATION = "\n)";
    private static final char BEGIN_LIST = '[';
    private static final char END_LIST = ']';
    private static final char BEGIN_STRING = '\'';
    private static final char END_STRING = '\'';
    private static final String DELIMITER = ",";
    private static final String SPACE = " ";
    private static final String[] LINE_PADDING_CACHE = new String[8];
    private final String value;
    private static final int MAX_DEPTH = 768;

    private Notation(String value) {
        this.value = Objects.requireNonNull(value);
    }

    public List<Object> parse() {
        return Notation.parse(this.value);
    }

    public static Notation forEncoding(byte[] rlp) {
        return new Notation(Notation.encodeToString(rlp));
    }

    public static String encodeToString(byte[] rlp) {
        return Notation.encodeToString(rlp, 0, rlp.length);
    }

    static String encodeToString(byte[] buffer, int index, int end) {
        StringBuilder sb = new StringBuilder(BEGIN_NOTATION);
        Notation.buildLongList(sb, buffer, index, end, 0);
        return sb.append(END_NOTATION).toString();
    }

    public static Notation forObjects(Object ... objects) {
        return Notation.forEncoding(RLPEncoder.sequence(objects));
    }

    public static Notation forObjects(Iterable<Object> objects) {
        return Notation.forEncoding(RLPEncoder.sequence(objects));
    }

    private static int buildString(StringBuilder sb, byte[] data, int from, int to, boolean addSpace) {
        int len = to - from;
        if (!Notation.DECODER.lenient && len == 1 && DataType.isSingleByte(data[from])) {
            throw new IllegalArgumentException("invalid rlp for single byte @ " + (from - 1));
        }
        sb.append('\'').append(Strings.encode(data, from, len, 0)).append(addSpace ? "', " : "',");
        return to;
    }

    private static int buildLongList(StringBuilder sb, byte[] data, int dataIndex, int end, int depth) {
        if (depth != 0) {
            sb.append('[');
        }
        Notation.buildListContent(sb, dataIndex, end, data, false, depth + 1);
        if (depth != 0) {
            sb.append(Notation.getLinePadding(depth)).append("],");
        }
        return end;
    }

    private static int buildShortList(StringBuilder sb, byte[] data, int dataIndex, int end, int depth, boolean addSpace) {
        sb.append("[ ");
        Notation.buildListContent(sb, dataIndex, end, data, true, depth + 1);
        sb.append(addSpace ? " ], " : " ],");
        return end;
    }

    private static void buildListContent(StringBuilder sb, int dataIndex, int end, byte[] data, boolean shortList, int elementDepth) {
        String elementPrefix = shortList ? null : Notation.getLinePadding(elementDepth);
        int i = dataIndex;
        while (i < end) {
            byte lead;
            DataType type;
            if (!shortList) {
                sb.append(elementPrefix);
            }
            if ((type = DataType.type(lead = data[i])) == DataType.SINGLE_BYTE) {
                i = Notation.buildString(sb, data, i, i + 1, shortList);
                continue;
            }
            if (type.isLong && shortList) {
                throw new IllegalArgumentException("long element found in short list");
            }
            int diff = lead - type.offset;
            int elementDataIdx = i + 1 + (type.isLong ? diff : 0);
            int elementEnd = ((RLPItem)Notation.DECODER.wrap((byte[])data, (int)i, (int)end)).endIndex;
            i = type.isString ? Notation.buildString(sb, data, elementDataIdx, elementEnd, shortList) : (type.isLong ? Notation.buildLongList(sb, data, elementDataIdx, elementEnd, elementDepth) : Notation.buildShortList(sb, data, elementDataIdx, elementEnd, elementDepth, shortList));
        }
        if (dataIndex != end) {
            sb.setLength(sb.length() - (shortList ? ", " : DELIMITER).length());
        }
    }

    private static String getLinePadding(int depth) {
        return depth < LINE_PADDING_CACHE.length ? LINE_PADDING_CACHE[depth] : Notation.newLinePadding(depth);
    }

    private static String newLinePadding(int depth) {
        byte[] prefix = new byte[1 + depth * 2];
        Arrays.fill(prefix, (byte)32);
        prefix[0] = 10;
        return new String(prefix, 0, 0, prefix.length);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof Notation && ((Notation)o).value.equals(this.value);
    }

    public String toString() {
        return this.value;
    }

    public static List<Object> parse(String notation) {
        ArrayList<Object> topLevelObjects = new ArrayList<Object>();
        if (Notation.parse(notation, 0, topLevelObjects, 0) != Integer.MAX_VALUE) {
            throw new IllegalArgumentException("syntax error");
        }
        return topLevelObjects;
    }

    private static int parse(String notation, int i, List<Object> parent, int depth) {
        do {
            switch (notation.charAt(i++)) {
                case '\'': {
                    int datumEnd = notation.indexOf(39, i);
                    if (datumEnd < 0) {
                        throw new IllegalArgumentException("unterminated string @ " + i);
                    }
                    parent.add(FastHex.decode(notation, i, datumEnd - i));
                    i = datumEnd + 1;
                    break;
                }
                case '[': {
                    if (depth >= 768) {
                        throw new IllegalArgumentException("exceeds max depth of 768");
                    }
                    ArrayList<Object> childList = new ArrayList<Object>();
                    i = Notation.parse(notation, i, childList, depth + 1);
                    parent.add(childList);
                    break;
                }
                case ']': {
                    return i;
                }
            }
        } while (i < notation.length());
        return Integer.MAX_VALUE;
    }

    static {
        for (int i = 0; i < LINE_PADDING_CACHE.length; ++i) {
            Notation.LINE_PADDING_CACHE[i] = Notation.newLinePadding(i);
        }
    }
}

