/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.editor;

import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.config.DefaultConfiguration;
import com.swirlds.platform.state.editor.StateEditorOperation;
import com.swirlds.platform.state.editor.StateEditorRoot;
import com.swirlds.platform.state.editor.StateEditorUtils;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.snapshot.SavedStateMetadata;
import com.swirlds.platform.state.snapshot.SignedStateFileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="save", mixinStandardHelpOptions=true, description={"Write the entire state to disk."})
@SubcommandOf(value=StateEditorRoot.class)
public class StateEditorSave
extends StateEditorOperation {
    private static final Logger logger = LogManager.getLogger(StateEditorSave.class);
    private Path directory;

    @CommandLine.Parameters(description={"The directory where the saved state should be written."})
    private void setFileName(Path directory) {
        this.directory = this.pathMustNotExist(FileUtils.getAbsolutePath((Path)directory));
    }

    @Override
    public void run() {
        try (ReservedSignedState reservedSignedState = this.getStateEditor().getState("StateEditorSave.run()");){
            Configuration configuration = DefaultConfiguration.buildBasicConfiguration(ConfigurationBuilder.create());
            PlatformContext platformContext = PlatformContext.create((Configuration)configuration);
            logger.info(LogMarker.CLI.getMarker(), "Hashing state");
            platformContext.getMerkleCryptography().digestTreeAsync(reservedSignedState.get().getState().getRoot()).get();
            if (logger.isInfoEnabled(LogMarker.CLI.getMarker())) {
                logger.info(LogMarker.CLI.getMarker(), "Writing signed state file to {}", (Object)StateEditorUtils.formatFile(this.directory));
            }
            if (!Files.exists(this.directory, new LinkOption[0])) {
                Files.createDirectories(this.directory, new FileAttribute[0]);
            }
            try (ReservedSignedState signedState = this.getStateEditor().getSignedStateCopy();){
                SignedStateFileWriter.writeSignedStateFilesToDirectory(platformContext, SavedStateMetadata.NO_NODE_ID, this.directory, signedState.get(), PlatformStateFacade.DEFAULT_PLATFORM_STATE_FACADE);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

