/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.InvalidOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class DataLoadNOperation
extends AbstractFixedCostOperation {
    public static final int OPCODE = 209;

    public DataLoadNOperation(GasCalculator gasCalculator) {
        super(209, "DATALOADN", 0, 1, gasCalculator, gasCalculator.getVeryLowTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        Code code = frame.getCode();
        if (code.getEofVersion() == 0) {
            return InvalidOperation.INVALID_RESULT;
        }
        int pc = frame.getPC();
        int index = code.readBigEndianU16(pc + 1);
        Bytes data = code.getData(index, 32);
        frame.pushStackItem(data);
        frame.setPC(pc + 2);
        return this.successResponse;
    }
}

