/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.datatypes;

import java.math.BigInteger;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.BaseUInt64Value;
import org.apache.tuweni.units.bigints.UInt64;
import org.hyperledger.besu.datatypes.Quantity;
import org.hyperledger.besu.datatypes.Wei;

public final class GWei
extends BaseUInt64Value<GWei>
implements Quantity {
    public static final GWei ZERO = GWei.of(0L);
    public static final GWei ONE = GWei.of(1L);
    public static final GWei MAX_GWEI = GWei.of(UInt64.MAX_VALUE);
    private static final BigInteger GWEI_TO_WEI_MULTIPLIER = BigInteger.valueOf(1000000000L);

    GWei(UInt64 value) {
        super(value, GWei::new);
    }

    private GWei(long v) {
        this(UInt64.valueOf((long)v));
    }

    private GWei(BigInteger v) {
        this(UInt64.valueOf((BigInteger)v));
    }

    private GWei(String hexString) {
        this(UInt64.fromHexString((String)hexString));
    }

    public static GWei of(long value) {
        return new GWei(value);
    }

    public static GWei of(BigInteger value) {
        return new GWei(value);
    }

    public static GWei of(UInt64 value) {
        return new GWei(value);
    }

    public static GWei wrap(Bytes value) {
        return new GWei(UInt64.fromBytes((Bytes)value));
    }

    public static GWei fromHexString(String str) {
        return new GWei(str);
    }

    public Wei getAsWei() {
        return Wei.of(this.getAsBigInteger().multiply(GWEI_TO_WEI_MULTIPLIER));
    }

    @Override
    public Number getValue() {
        return this.getAsBigInteger();
    }

    @Override
    public BigInteger getAsBigInteger() {
        return this.toBigInteger();
    }

    @Override
    public String toHexString() {
        return super.toHexString();
    }

    @Override
    public String toShortHexString() {
        return super.isZero() ? "0x0" : super.toShortHexString();
    }
}

