/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl.rules;

import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.LongSupplier;
import org.hiero.consensus.event.creator.config.EventCreationConfig;
import org.hiero.consensus.event.creator.impl.EventCreationStatus;
import org.hiero.consensus.event.creator.impl.rules.EventCreationRule;

public class BackpressureRule
implements EventCreationRule {
    private final int eventIntakeThrottle;
    private final LongSupplier eventIntakeQueueSize;

    public BackpressureRule(@NonNull Configuration configuration, @NonNull LongSupplier eventIntakeQueueSize) {
        EventCreationConfig eventCreationConfig = (EventCreationConfig)configuration.getConfigData(EventCreationConfig.class);
        this.eventIntakeThrottle = eventCreationConfig.eventIntakeThrottle();
        this.eventIntakeQueueSize = Objects.requireNonNull(eventIntakeQueueSize);
    }

    @Override
    public boolean isEventCreationPermitted() {
        return this.eventIntakeQueueSize.getAsLong() < (long)this.eventIntakeThrottle;
    }

    @Override
    public void eventWasCreated() {
    }

    @Override
    @NonNull
    public EventCreationStatus getEventCreationStatus() {
        return EventCreationStatus.OVERLOADED;
    }
}

