/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.utils;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Key;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public final class KeyValueWrapper {
    private final boolean shouldInheritAccountKey;
    private final ContractID contractID;
    private final byte[] ed25519;
    private final byte[] ecdsaSecp256k1;
    private final ContractID delegatableContractID;
    private final KeyType keyType;
    private static final int ED25519_BYTE_LENGTH = 32;
    private static final int ECDSA_SECP256K1_COMPRESSED_KEY_LENGTH = 33;
    private Key inheritedKey;

    public KeyValueWrapper(boolean shouldInheritAccountKey, @Nullable ContractID contractID, @NonNull byte[] ed25519, @NonNull byte[] ecdsaSecp256k1, @Nullable ContractID delegatableContractID) {
        this.shouldInheritAccountKey = shouldInheritAccountKey;
        this.contractID = contractID;
        this.ed25519 = Objects.requireNonNull(ed25519);
        this.ecdsaSecp256k1 = Objects.requireNonNull(ecdsaSecp256k1);
        this.delegatableContractID = delegatableContractID;
        this.keyType = this.isValidConstruction() ? this.computeKeyType() : KeyType.INVALID_KEY;
    }

    private boolean isContractIDSet() {
        return this.contractID != null;
    }

    private boolean isDelegatableContractIdSet() {
        return this.delegatableContractID != null;
    }

    public boolean isShouldInheritAccountKeySet() {
        return this.shouldInheritAccountKey;
    }

    private boolean isEd25519KeySet() {
        return this.ed25519.length == 32;
    }

    private boolean isEcdsaSecp256k1KeySet() {
        return this.ecdsaSecp256k1.length == 33;
    }

    public void setInheritedKey(Key key) {
        this.inheritedKey = key;
    }

    private boolean isValidConstruction() {
        int keyCount = 0;
        if (this.isContractIDSet()) {
            ++keyCount;
        }
        if (this.isDelegatableContractIdSet()) {
            ++keyCount;
        }
        if (this.isShouldInheritAccountKeySet()) {
            ++keyCount;
        }
        if (this.isEd25519KeySet()) {
            ++keyCount;
        }
        if (this.isEcdsaSecp256k1KeySet()) {
            ++keyCount;
        }
        return keyCount == 1;
    }

    private KeyType computeKeyType() {
        if (this.isShouldInheritAccountKeySet()) {
            return KeyType.INHERIT_ACCOUNT_KEY;
        }
        if (this.isContractIDSet()) {
            return KeyType.CONTRACT_ID;
        }
        if (this.isEd25519KeySet()) {
            return KeyType.ED25519;
        }
        if (this.isEcdsaSecp256k1KeySet()) {
            return KeyType.ECDSA_SECP256K1;
        }
        return KeyType.DELEGATABLE_CONTRACT_ID;
    }

    public Key asGrpc() {
        return switch (this.keyType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Key.DEFAULT;
            case 1 -> this.inheritedKey;
            case 2 -> Key.newBuilder().contractID(this.contractID).build();
            case 4 -> Key.newBuilder().ed25519(Bytes.wrap((byte[])this.ed25519)).build();
            case 5 -> Key.newBuilder().ecdsaSecp256k1(Bytes.wrap((byte[])this.ecdsaSecp256k1)).build();
            case 3 -> Key.newBuilder().delegatableContractId(this.delegatableContractID).build();
        };
    }

    public static enum KeyType {
        INVALID_KEY,
        INHERIT_ACCOUNT_KEY,
        CONTRACT_ID,
        DELEGATABLE_CONTRACT_ID,
        ED25519,
        ECDSA_SECP256K1;

    }
}

