/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.networkadmin.impl.handlers;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class UnzipUtility {
    private static final Logger log = LogManager.getLogger(UnzipUtility.class);
    private static final int BUFFER_SIZE = 4096;

    private UnzipUtility() {
    }

    public static void unzip(@NonNull byte[] bytes, @NonNull Path dstDir) throws IOException {
        Objects.requireNonNull(bytes);
        Objects.requireNonNull(dstDir);
        try (ZipInputStream zipIn = new ZipInputStream(new ByteArrayInputStream(bytes));){
            ZipEntry entry = zipIn.getNextEntry();
            if (entry == null) {
                throw new IOException("No zip entry found in bytes");
            }
            while (entry != null) {
                Path filePath = dstDir.resolve(entry.getName());
                File fileOrDir = filePath.toFile();
                String canonicalPath = fileOrDir.getCanonicalPath();
                if (!canonicalPath.startsWith(dstDir.toFile().getCanonicalPath())) {
                    throw new IOException("Zip file entry is outside of the destination directory: " + String.valueOf(filePath));
                }
                File directory = fileOrDir.getParentFile();
                if (!directory.exists() && !directory.mkdirs()) {
                    throw new IOException("Unable to create the parent directories for the file: " + String.valueOf(fileOrDir));
                }
                if (!entry.isDirectory()) {
                    UnzipUtility.extractSingleFile(zipIn, filePath);
                    log.info(" - Extracted update file {}", (Object)filePath);
                } else {
                    if (!fileOrDir.exists() && !fileOrDir.mkdirs()) {
                        throw new IOException("Unable to create assets sub-directory: " + String.valueOf(fileOrDir));
                    }
                    log.info(" - Created assets sub-directory {}", (Object)fileOrDir);
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
    }

    public static void extractSingleFile(@NonNull ZipInputStream inputStream, @NonNull Path filePath) throws IOException {
        Objects.requireNonNull(inputStream);
        Objects.requireNonNull(filePath);
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath.toFile()));){
            int read;
            byte[] bytesIn = new byte[4096];
            while ((read = inputStream.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
        }
    }
}

