/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.synchronization;

import com.swirlds.base.time.Time;
import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.MerkleDataOutputStream;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.merkle.synchronization.streams.AsyncOutputStream;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.merkle.synchronization.views.TeacherTreeView;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.SocketException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.consensus.concurrent.manager.ThreadManager;
import org.hiero.consensus.concurrent.pool.StandardWorkGroup;

public class TeachingSynchronizer {
    private static final String WORK_GROUP_NAME = "teaching-synchronizer";
    private static final Logger logger = LogManager.getLogger(TeachingSynchronizer.class);
    private final MerkleDataInputStream inputStream;
    private final MerkleDataOutputStream outputStream;
    private final TeacherTreeView<?> view;
    private final Runnable breakConnection;
    private final ThreadManager threadManager;
    protected final ReconnectConfig reconnectConfig;
    private final Time time;

    public TeachingSynchronizer(@NonNull Time time, @NonNull ThreadManager threadManager, @NonNull MerkleDataInputStream in, @NonNull MerkleDataOutputStream out, @NonNull TeacherTreeView<?> view, @Nullable Runnable breakConnection, @NonNull ReconnectConfig reconnectConfig) {
        this.time = Objects.requireNonNull(time);
        this.threadManager = Objects.requireNonNull(threadManager, "threadManager must not be null");
        this.inputStream = Objects.requireNonNull(in, "in must not be null");
        this.outputStream = Objects.requireNonNull(out, "out must not be null");
        this.view = Objects.requireNonNull(view, "view must not be null");
        this.breakConnection = breakConnection;
        this.reconnectConfig = Objects.requireNonNull(reconnectConfig, "reconnectConfig must not be null");
    }

    public void synchronize() throws InterruptedException {
        try {
            this.sendTree();
        }
        finally {
            this.view.close();
        }
    }

    private void sendTree() throws InterruptedException {
        AtomicReference firstReconnectException = new AtomicReference();
        StandardWorkGroup workGroup = this.createStandardWorkGroup(this.threadManager, this.breakConnection, cause -> {
            while (cause != null) {
                SocketException socketEx;
                if (cause instanceof SocketException && (socketEx = (SocketException)cause).getMessage().equalsIgnoreCase("Connection reset by peer")) {
                    logger.info(LogMarker.RECONNECT.getMarker(), "Connection reset while sending tree. Aborting");
                    return true;
                }
                cause = cause.getCause();
            }
            firstReconnectException.compareAndSet(null, cause);
            return false;
        });
        this.view.startTeacherTasks(this, this.time, workGroup, this.inputStream, this.outputStream);
        workGroup.waitForTermination();
        if (workGroup.hasExceptions()) {
            throw new MerkleSynchronizationException("Synchronization failed with exceptions", (Throwable)firstReconnectException.get());
        }
        logger.info(LogMarker.RECONNECT.getMarker(), "finished sending tree");
    }

    protected StandardWorkGroup createStandardWorkGroup(ThreadManager threadManager, Runnable breakConnection, Function<Throwable, Boolean> exceptionListener) {
        return new StandardWorkGroup(threadManager, WORK_GROUP_NAME, breakConnection, exceptionListener);
    }

    public <T extends SelfSerializable> AsyncOutputStream<T> buildOutputStream(StandardWorkGroup workGroup, SerializableDataOutputStream out) {
        return new AsyncOutputStream(out, workGroup, this.reconnectConfig);
    }
}

