/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.token.TokenUnpauseTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.fees.usage.token.TokenOpsUsageUtils;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenUnpauseMeta;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.WritableTokenStore;
import com.hedera.node.app.service.token.records.TokenBaseStreamBuilder;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenUnpauseHandler
implements TransactionHandler {
    @Inject
    public TokenUnpauseHandler() {
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        Objects.requireNonNull(txn);
        TokenUnpauseTransactionBody op = txn.tokenUnpauseOrThrow();
        if (!op.hasToken()) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TOKEN_ID);
        }
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TokenUnpauseTransactionBody op = context.body().tokenUnpause();
        ReadableTokenStore tokenStore = (ReadableTokenStore)context.createStore(ReadableTokenStore.class);
        ReadableTokenStore.TokenMetadata tokenMeta = tokenStore.getTokenMeta(op.tokenOrElse(TokenID.DEFAULT));
        if (tokenMeta == null) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TOKEN_ID);
        }
        if (tokenMeta.hasPauseKey()) {
            context.requireKey(tokenMeta.pauseKey());
        }
    }

    public void handle(@NonNull HandleContext context) {
        Objects.requireNonNull(context);
        TokenUnpauseTransactionBody op = context.body().tokenUnpause();
        WritableTokenStore tokenStore = (WritableTokenStore)context.storeFactory().writableStore(WritableTokenStore.class);
        Token token = tokenStore.get(op.tokenOrElse(TokenID.DEFAULT));
        HandleException.validateTrue((token != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
        HandleException.validateFalse((boolean)token.deleted(), (ResponseCodeEnum)ResponseCodeEnum.TOKEN_WAS_DELETED);
        HandleException.validateTrue((boolean)token.hasPauseKey(), (ResponseCodeEnum)ResponseCodeEnum.TOKEN_HAS_NO_PAUSE_KEY);
        Token.Builder copyBuilder = token.copyBuilder();
        copyBuilder.paused(false);
        tokenStore.put(copyBuilder.build());
        TokenBaseStreamBuilder recordBuilder = (TokenBaseStreamBuilder)context.savepointStack().getBaseBuilder(TokenBaseStreamBuilder.class);
        recordBuilder.tokenType(token.tokenType());
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        TokenUnpauseMeta meta = TokenOpsUsageUtils.TOKEN_OPS_USAGE_UTILS.tokenUnpauseUsageFrom();
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).addBytesPerTransaction((long)meta.getBpt()).calculate();
    }
}

