/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.metrics;

import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.metrics.api.LongGauge;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.eventhandling.TransactionHandlerPhase;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.Objects;
import org.hiero.consensus.metrics.extensions.PhaseTimer;
import org.hiero.consensus.metrics.extensions.PhaseTimerBuilder;

public class RoundHandlingMetrics {
    private static final LongGauge.Config consensusTimeConfig = new LongGauge.Config("internal", "consensusTime").withDescription("The consensus timestamp of the round currently being handled.").withUnit("milliseconds");
    private final LongGauge consensusTime;
    private static final LongGauge.Config consensusTimeDeviationConfig = new LongGauge.Config("internal", "consensusTimeDeviation").withDescription("The difference between the consensus time of the round currently being handled and this node's wall clock time. Positive values mean that this node's clock is behind the consensustime, negative values mean that it's ahead.").withUnit("milliseconds");
    private final LongGauge consensusTimeDeviation;
    private static final LongGauge.Config eventsPerRoundConfig = new LongGauge.Config("internal", "eventsPerRound").withDescription("The number of events per round").withUnit("count");
    private final LongGauge eventsPerRound;
    private final PhaseTimer<TransactionHandlerPhase> roundHandlerPhase;
    private final Time time;

    public RoundHandlingMetrics(@NonNull PlatformContext platformContext) {
        this.time = platformContext.getTime();
        Metrics metrics = platformContext.getMetrics();
        this.consensusTime = (LongGauge)metrics.getOrCreate((MetricConfig)consensusTimeConfig);
        this.consensusTimeDeviation = (LongGauge)metrics.getOrCreate((MetricConfig)consensusTimeDeviationConfig);
        this.eventsPerRound = (LongGauge)metrics.getOrCreate((MetricConfig)eventsPerRoundConfig);
        this.roundHandlerPhase = new PhaseTimerBuilder(metrics, this.time, "platform", TransactionHandlerPhase.class).enableFractionalMetrics().setInitialPhase((Enum)TransactionHandlerPhase.IDLE).setMetricsNamePrefix("consensus").build();
    }

    public void recordEventsPerRound(int eventCount) {
        this.eventsPerRound.set((long)eventCount);
    }

    public void recordConsensusTime(@NonNull Instant consensusTime) {
        this.consensusTime.set(consensusTime.toEpochMilli());
        this.consensusTimeDeviation.set(consensusTime.toEpochMilli() - this.time.now().toEpochMilli());
    }

    public void setPhase(@NonNull TransactionHandlerPhase phase) {
        Objects.requireNonNull(phase);
        this.roundHandlerPhase.activatePhase((Enum)phase);
    }
}

