/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIJSON;
import com.esaulpaugh.headlong.abi.ABIObject;
import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.ByteType;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.TypeEnum;
import com.esaulpaugh.headlong.abi.TypeFactory;
import com.esaulpaugh.headlong.util.FastHex;
import com.esaulpaugh.headlong.util.Strings;
import com.joemelsha.crypto.hash.Keccak;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Objects;

public final class Event<J extends Tuple>
implements ABIObject {
    private static final ArrayType<ByteType, Byte, byte[]> BYTES_32 = (ArrayType)TypeFactory.create("bytes32");
    public static final byte[][] EMPTY_TOPICS = new byte[0][];
    private final String name;
    private final boolean anonymous;
    private final TupleType<J> inputs;
    private final TupleType<?> indexedParams;
    private final TupleType<?> nonIndexedParams;
    private final boolean[] indexManifest;
    private final byte[] signatureHash;

    public static <X extends Tuple> Event<X> create(String name, TupleType<X> inputs, boolean ... indexed) {
        return new Event<X>(name, false, inputs, indexed);
    }

    public static <X extends Tuple> Event<X> createAnonymous(String name, TupleType<X> inputs, boolean ... indexed) {
        return new Event<X>(name, true, inputs, indexed);
    }

    public Event(String name, boolean anonymous, TupleType<J> inputs, boolean ... indexed) {
        this.name = Objects.requireNonNull(name);
        this.anonymous = anonymous;
        this.inputs = Objects.requireNonNull(inputs);
        if (indexed.length != inputs.size()) {
            throw new IllegalArgumentException("indexed.length doesn't match number of inputs");
        }
        this.indexManifest = Arrays.copyOf(indexed, indexed.length);
        this.indexedParams = inputs.select(this.indexManifest);
        this.nonIndexedParams = inputs.exclude(this.indexManifest);
        this.signatureHash = new Keccak(256).digest(Strings.decode(this.getCanonicalSignature(), 3));
    }

    @Override
    public TypeEnum getType() {
        return TypeEnum.EVENT;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public TupleType<J> getInputs() {
        return this.inputs;
    }

    public boolean[] getIndexManifest() {
        return Arrays.copyOf(this.indexManifest, this.indexManifest.length);
    }

    public boolean isElementIndexed(int position) {
        return this.indexManifest[position];
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public String getCanonicalSignature() {
        return this.name + this.inputs.canonicalType;
    }

    public <X extends Tuple> TupleType<X> getIndexedParams() {
        return this.indexedParams;
    }

    public <X extends Tuple> TupleType<X> getNonIndexedParams() {
        return this.nonIndexedParams;
    }

    @Override
    public boolean isEvent() {
        return true;
    }

    public int hashCode() {
        return 31 * (31 * (31 * this.name.hashCode() + this.inputs.hashCode()) + Arrays.hashCode(this.indexManifest)) + Boolean.hashCode(this.anonymous);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        return other.anonymous == this.anonymous && other.name.equals(this.name) && other.inputs.equals(this.inputs) && Arrays.equals(other.indexManifest, this.indexManifest);
    }

    public String toString() {
        return this.toJson(true);
    }

    public <T extends Tuple> T decodeTopics(byte[][] topics) {
        return (T)Tuple.create(this.decodeTopicsArray(topics));
    }

    public <T extends Tuple> T decodeData(byte[] data) {
        return (T)(data == null && this.nonIndexedParams.isEmpty() ? Tuple.EMPTY : (Tuple)this.nonIndexedParams.decode(data));
    }

    public <T extends Tuple> T decodeArgs(byte[][] topics, byte[] data) {
        return (T)this.mergeDecodedArgs(this.decodeTopicsArray(topics), (Tuple)this.decodeData(data));
    }

    private Tuple mergeDecodedArgs(Object[] decodedTopics, Tuple decodedData) {
        Object[] result = new Object[this.inputs.size()];
        int topicIndex = 0;
        int dataIndex = 0;
        for (int i = 0; i < this.indexManifest.length; ++i) {
            result[i] = this.indexManifest[i] ? decodedTopics[topicIndex++] : decodedData.get(dataIndex++);
        }
        return Tuple.create(result);
    }

    private Object[] decodeTopicsArray(byte[][] topics) {
        this.checkTopics(topics);
        int offset = this.anonymous ? 0 : 1;
        Object[] decodedTopics = new Object[this.indexedParams.size()];
        for (int i = 0; i < decodedTopics.length; ++i) {
            Object abiType = this.indexedParams.get(i);
            byte[] topic = topics[i + offset];
            decodedTopics[i] = ((ABIType)abiType).isDynamic() ? BYTES_32.decode(topic) : ((ABIType)abiType).decode(topic);
        }
        return decodedTopics;
    }

    private void checkTopics(byte[][] topics) {
        int expectedTopics;
        int size = this.indexedParams.size();
        if (this.anonymous) {
            if (size == 0 && topics == null) {
                topics = EMPTY_TOPICS;
            }
            expectedTopics = size;
        } else {
            byte[] decodedSignatureHash = (byte[])BYTES_32.decode(topics[0]);
            if (!MessageDigest.isEqual(this.signatureHash, decodedSignatureHash)) {
                throw new IllegalArgumentException("unexpected topics[0]: event " + this.getCanonicalSignature() + " expects " + FastHex.encodeToString(this.signatureHash) + " but found " + FastHex.encodeToString(decodedSignatureHash));
            }
            expectedTopics = size + 1;
        }
        if (topics.length != expectedTopics) {
            throw new IllegalArgumentException("expected topics.length " + expectedTopics + " but found length " + topics.length);
        }
    }

    public static <X extends Tuple> Event<X> fromJson(String eventJson) {
        return Event.fromJson(0, eventJson);
    }

    public static <X extends Tuple> Event<X> fromJson(int flags, String eventJson) {
        return (Event)ABIJSON.parseABIObject(eventJson, ABIJSON.EVENTS, null, flags);
    }

    public static <X extends Tuple> Event<X> fromJson(int flags, InputStream jsonStream) {
        return (Event)ABIJSON.parseABIObject(jsonStream, ABIJSON.EVENTS, null, flags);
    }
}

