/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.component.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;

public class WiringComponentProxy
implements InvocationHandler {
    private Method mostRecentlyInvokedMethod = null;

    @Override
    public Object invoke(@NonNull Object proxy, @NonNull Method method, @NonNull Object[] args) throws Throwable {
        if (method.getName().equals("toString")) {
            return "WiringComponentProxy";
        }
        this.mostRecentlyInvokedMethod = Objects.requireNonNull(method);
        return null;
    }

    @NonNull
    public Method getMostRecentlyInvokedMethod() {
        if (this.mostRecentlyInvokedMethod == null) {
            throw new IllegalArgumentException("Provided lambda is not a method on the component interface.");
        }
        try {
            Method method = this.mostRecentlyInvokedMethod;
            return method;
        }
        finally {
            this.mostRecentlyInvokedMethod = null;
        }
    }
}

