/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HookEntityId;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.hooks.HookCreationDetails;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.token.CryptoUpdateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.fees.usage.SingletonEstimatorUtils;
import com.hedera.node.app.hapi.fees.usage.crypto.entities.CryptoEntitySizes;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hedera.node.app.service.token.CryptoSignatureWaivers;
import com.hedera.node.app.service.token.HookDispatchUtils;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.api.AccountSummariesApi;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.handlers.BaseCryptoHandler;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.service.token.impl.validators.StakingValidator;
import com.hedera.node.app.service.token.records.CryptoUpdateStreamBuilder;
import com.hedera.node.app.spi.fees.FeeCalculator;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.validation.AttributeValidator;
import com.hedera.node.app.spi.validation.ExpiryMeta;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.AutoRenewConfig;
import com.hedera.node.config.data.EntitiesConfig;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.node.config.data.TokensConfig;
import com.hederahashgraph.api.proto.java.Key;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CryptoUpdateHandler
extends BaseCryptoHandler
implements TransactionHandler {
    private final CryptoSignatureWaivers waivers;

    @Inject
    public CryptoUpdateHandler(@NonNull CryptoSignatureWaivers waivers) {
        this.waivers = Objects.requireNonNull(waivers, "The supplied argument 'waivers' must not be null");
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        CryptoUpdateTransactionBody op = txn.cryptoUpdateAccountOrThrow();
        PreCheckException.validateTruePreCheck((boolean)op.hasAccountIDToUpdate(), (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_ID_DOES_NOT_EXIST);
        PreCheckException.validateFalsePreCheck((op.hasProxyAccountID() && !op.proxyAccountID().equals((Object)AccountID.DEFAULT) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.PROXY_ACCOUNT_ID_FIELD_IS_DEPRECATED);
        HookDispatchUtils.validateHookDuplicates((List)op.hookCreationDetails());
        if (!op.hookIdsToDelete().isEmpty()) {
            long distinctHookIds = op.hookIdsToDelete().stream().distinct().count();
            PreCheckException.validateTruePreCheck((distinctHookIds == (long)op.hookIdsToDelete().size() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOK_ID_REPEATED_IN_CREATION_DETAILS);
        }
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        boolean newAccountKeyMustSign;
        Objects.requireNonNull(context);
        Objects.requireNonNull(this.waivers);
        TransactionBody txn = context.body();
        AccountID payer = context.payer();
        CryptoUpdateTransactionBody op = txn.cryptoUpdateAccountOrThrow();
        AccountID updateAccountId = op.accountIDToUpdateOrThrow();
        boolean targetAccountKeyMustSign = !this.waivers.isTargetAccountSignatureWaived(txn, payer);
        boolean bl = newAccountKeyMustSign = !this.waivers.isNewKeySignatureWaived(txn, payer);
        if (targetAccountKeyMustSign) {
            context.requireKeyOrThrow(updateAccountId, ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
        if (newAccountKeyMustSign && op.hasKey()) {
            context.requireKeyOrThrow(op.key(), ResponseCodeEnum.INVALID_ADMIN_KEY);
        }
    }

    public void handle(@NonNull HandleContext context) {
        TransactionBody txn = Objects.requireNonNull(context).body();
        CryptoUpdateTransactionBody op = txn.cryptoUpdateAccountOrThrow();
        AccountID target = op.accountIDToUpdateOrThrow();
        WritableAccountStore accountStore = (WritableAccountStore)context.storeFactory().writableStore(WritableAccountStore.class);
        Account targetAccount = TokenHandlerHelper.getIfUsable(target, accountStore, context.expiryValidator(), ResponseCodeEnum.INVALID_ACCOUNT_ID);
        context.attributeValidator().validateMemo(op.memo());
        Account.Builder builder = this.updateBuilder(op, targetAccount);
        this.validateSemantics(context, targetAccount, op, builder, accountStore);
        if (targetAccount.expiredAndPendingRemoval()) {
            builder.expiredAndPendingRemoval(false);
        }
        this.updateHooks(context, targetAccount, op, builder);
        accountStore.put(builder.build());
        ((CryptoUpdateStreamBuilder)context.savepointStack().getBaseBuilder(CryptoUpdateStreamBuilder.class)).accountID(targetAccount.accountIdOrThrow());
    }

    private void updateHooks(@NonNull HandleContext context, Account targetAccount, CryptoUpdateTransactionBody op, Account.Builder builder) {
        Long headAfterDeletes;
        HookEntityId hookEntityId = HookEntityId.newBuilder().accountId(op.accountIDToUpdateOrThrow()).build();
        Long l = headAfterDeletes = targetAccount.numberHooksInUse() > 0L ? Long.valueOf(targetAccount.firstHookId()) : null;
        if (!op.hookIdsToDelete().isEmpty()) {
            headAfterDeletes = HookDispatchUtils.dispatchHookDeletions((HandleContext)context, (List)op.hookIdsToDelete(), (Long)headAfterDeletes, (HookEntityId)hookEntityId);
        }
        if (!op.hookCreationDetails().isEmpty()) {
            int updatedSlots = HookDispatchUtils.dispatchHookCreations((HandleContext)context, (List)op.hookCreationDetails(), (Long)headAfterDeletes, (HookEntityId)hookEntityId);
            builder.numberEvmHookStorageSlots(targetAccount.numberEvmHookStorageSlots() + (long)updatedSlots);
        }
        if (!op.hookCreationDetails().isEmpty()) {
            builder.firstHookId(((HookCreationDetails)op.hookCreationDetails().getFirst()).hookId());
        } else if (!op.hookIdsToDelete().isEmpty()) {
            builder.firstHookId(headAfterDeletes == null ? 0L : headAfterDeletes);
        }
    }

    private Account.Builder updateBuilder(@NonNull CryptoUpdateTransactionBody op, @NonNull Account currentAccount) {
        Account.Builder builder = currentAccount.copyBuilder();
        if (op.hasKey()) {
            builder.key(op.key());
        }
        if (op.hasExpirationTime()) {
            builder.expirationSecond(op.expirationTime().seconds());
        }
        if (op.hasReceiverSigRequiredWrapper()) {
            builder.receiverSigRequired(op.receiverSigRequiredWrapper().booleanValue());
        } else if (op.hasReceiverSigRequired()) {
            builder.receiverSigRequired(op.receiverSigRequired().booleanValue());
        }
        if (op.hasAutoRenewPeriod()) {
            builder.autoRenewSeconds(op.autoRenewPeriod().seconds());
        }
        if (op.hasMemo()) {
            builder.memo(op.memo());
        }
        if (op.hasMaxAutomaticTokenAssociations()) {
            builder.maxAutoAssociations(op.maxAutomaticTokenAssociations().intValue());
        }
        if (op.hasDeclineReward()) {
            builder.declineReward(op.declineReward().booleanValue());
        }
        if (op.hasStakedAccountId()) {
            if (AccountSummariesApi.SENTINEL_ACCOUNT_ID.equals((Object)op.stakedAccountId())) {
                builder.stakedAccountId((AccountID)null);
            } else {
                builder.stakedAccountId(op.stakedAccountId());
            }
        } else if (op.hasStakedNodeId()) {
            if (-1L == op.stakedNodeId()) {
                builder.stakedNodeId(-1L);
            } else {
                builder.stakedNodeId(op.stakedNodeId().longValue());
            }
        }
        if (!op.hookCreationDetails().isEmpty() || !op.hookIdsToDelete().isEmpty()) {
            long currentHooks = currentAccount.numberHooksInUse();
            builder.numberHooksInUse(currentHooks - (long)op.hookIdsToDelete().size() + (long)op.hookCreationDetails().size());
        }
        return builder;
    }

    private void validateSemantics(@NonNull HandleContext context, @NonNull Account updateAccount, @NonNull CryptoUpdateTransactionBody op, @NonNull Account.Builder builder, @NonNull ReadableAccountStore accountStore) {
        ExpiryValidator expiryValidator = context.expiryValidator();
        Account builderAccount = builder.build();
        this.validateFields(op, context, accountStore);
        HandleException.validateTrue((!updateAccount.smartContract() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
        TokensConfig tokensConfig = (TokensConfig)context.configuration().getConfigData(TokensConfig.class);
        LedgerConfig ledgerConfig = (LedgerConfig)context.configuration().getConfigData(LedgerConfig.class);
        EntitiesConfig entitiesConfig = (EntitiesConfig)context.configuration().getConfigData(EntitiesConfig.class);
        ExpiryMeta currentMetadata = new ExpiryMeta(updateAccount.expirationSecond(), updateAccount.autoRenewSeconds(), updateAccount.autoRenewAccountId());
        ExpiryMeta updateMeta = new ExpiryMeta(op.hasExpirationTime() ? op.expirationTime().seconds() : ExpiryMeta.NA, op.hasAutoRenewPeriod() ? op.autoRenewPeriod().seconds() : ExpiryMeta.NA, null);
        context.expiryValidator().resolveUpdateAttempt(currentMetadata, updateMeta);
        if (expiryValidator.isDetached(EntityType.ACCOUNT, updateAccount.expiredAndPendingRemoval(), updateAccount.tinybarBalance())) {
            HandleException.validateTrue((builderAccount.expirationSecond() != 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_EXPIRED_AND_PENDING_REMOVAL);
        }
        if (op.hasMaxAutomaticTokenAssociations()) {
            long newMax = builderAccount.maxAutoAssociations();
            HandleException.validateFalse((entitiesConfig.limitTokenAssociations() && newMax > (long)tokensConfig.maxPerAccount() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.REQUESTED_NUM_AUTOMATIC_ASSOCIATIONS_EXCEEDS_ASSOCIATION_LIMIT);
            HandleException.validateFalse((newMax < -1L && entitiesConfig.unlimitedAutoAssociationsEnabled() || newMax < 0L && !entitiesConfig.unlimitedAutoAssociationsEnabled() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_MAX_AUTO_ASSOCIATIONS);
            HandleException.validateFalse((newMax < (long)updateAccount.usedAutoAssociations() && newMax != -1L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.EXISTING_AUTOMATIC_ASSOCIATIONS_EXCEED_GIVEN_LIMIT);
            HandleException.validateFalse((newMax > (long)ledgerConfig.maxAutoAssociations() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.REQUESTED_NUM_AUTOMATIC_ASSOCIATIONS_EXCEEDS_ASSOCIATION_LIMIT);
        }
        HandleException.validateFalse((boolean)updateAccount.deleted(), (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_DELETED);
    }

    private void validateFields(@NonNull CryptoUpdateTransactionBody op, @NonNull HandleContext context, @NonNull ReadableAccountStore accountStore) {
        if (op.hasMemo()) {
            context.attributeValidator().validateMemo(op.memo());
        }
        if (op.hasKey() && !AttributeValidator.isImmutableKey((com.hedera.hapi.node.base.Key)op.key())) {
            context.attributeValidator().validateKey(op.key());
        }
        if (op.hasAutoRenewPeriod()) {
            context.attributeValidator().validateAutoRenewPeriod(op.autoRenewPeriod().seconds());
        }
        StakingValidator.validateStakedIdForUpdate(op.hasDeclineReward(), ((CryptoUpdateTransactionBody.StakedIdOneOfType)op.stakedId().kind()).name(), op.stakedAccountId(), op.stakedNodeId(), accountStore, context.networkInfo());
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        TransactionBody body = feeContext.body();
        ReadableAccountStore accountStore = (ReadableAccountStore)feeContext.readableStore(ReadableAccountStore.class);
        return this.cryptoUpdateFees(body, feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT), accountStore, feeContext.configuration());
    }

    private static long baseSizeOf(CryptoUpdateTransactionBody txBody, long keySize) {
        return (long)(24 + txBody.memoOrElse("").getBytes(StandardCharsets.UTF_8).length) + (txBody.hasExpirationTime() ? 8L : 0L) + (txBody.hasAutoRenewPeriod() ? 8L : 0L) + (txBody.hasProxyAccountID() ? 24L : 0L) + (txBody.hasMaxAutomaticTokenAssociations() ? 4L : 0L) + keySize;
    }

    private static long cryptoAutoRenewRb(@Nullable Account account) {
        int fixedBytes = CryptoEntitySizes.CRYPTO_ENTITY_SIZES.fixedBytesInAccountRepr();
        if (account == null) {
            return fixedBytes;
        }
        return (long)(fixedBytes + CryptoUpdateHandler.currentNonBaseBytes(account)) + (long)account.numberAssociations() * CryptoEntitySizes.CRYPTO_ENTITY_SIZES.bytesInTokenAssocRepr();
    }

    private static int currentNonBaseBytes(Account account) {
        int accountMemoSize = account == null || account.memo() == null ? 0 : account.memo().getBytes(StandardCharsets.UTF_8).length;
        return accountMemoSize + FeeBuilder.getAccountKeyStorageSize((Key)CommonPbjConverters.fromPbj((com.hedera.hapi.node.base.Key)account.keyOrElse(com.hedera.hapi.node.base.Key.DEFAULT))) + (account.maxAutoAssociations() == 0 ? 0 : 4);
    }

    private Fees cryptoUpdateFees(TransactionBody body, FeeCalculator feeCalculator, ReadableAccountStore accountStore, Configuration configuration) {
        CryptoUpdateTransactionBody op = body.cryptoUpdateAccountOrThrow();
        Account account = accountStore.getAccountById(op.accountIDToUpdateOrElse(AccountID.DEFAULT));
        AutoRenewConfig autoRenewconfig = (AutoRenewConfig)configuration.getConfigData(AutoRenewConfig.class);
        EntitiesConfig entityConfig = (EntitiesConfig)configuration.getConfigData(EntitiesConfig.class);
        boolean unlimitedAutoAssoc = entityConfig.unlimitedAutoAssociationsEnabled();
        long explicitAutoAssocSlotLifetime = autoRenewconfig.expireAccounts() ? 0L : 7776000L;
        long keySize = op.hasKey() ? (long)FeeBuilder.getAccountKeyStorageSize((Key)CommonPbjConverters.fromPbj((com.hedera.hapi.node.base.Key)op.keyOrThrow())) : 0L;
        long baseSize = CryptoUpdateHandler.baseSizeOf(op, keySize);
        int newMemoSize = op.memoOrElse("").getBytes(StandardCharsets.UTF_8).length;
        long accountMemoSize = account == null || account.memo() == null ? 0L : (long)account.memo().getBytes(StandardCharsets.UTF_8).length;
        long newVariableBytes = ((long)newMemoSize != 0L ? (long)newMemoSize : accountMemoSize) + (keySize == 0L && account != null ? (long)FeeBuilder.getAccountKeyStorageSize((Key)CommonPbjConverters.fromPbj((com.hedera.hapi.node.base.Key)account.keyOrElse(com.hedera.hapi.node.base.Key.DEFAULT))) : keySize);
        long tokenRelBytes = (long)(account == null ? 0 : account.numberAssociations()) * CryptoEntitySizes.CRYPTO_ENTITY_SIZES.bytesInTokenAssocRepr();
        long sharedFixedBytes = (long)CryptoEntitySizes.CRYPTO_ENTITY_SIZES.fixedBytesInAccountRepr() + tokenRelBytes;
        long effectiveNow = body.transactionIDOrThrow().transactionValidStartOrThrow().seconds();
        long newLifetime = SingletonEstimatorUtils.ESTIMATOR_UTILS.relativeLifetime(effectiveNow, op.expirationTimeOrElse(Timestamp.DEFAULT).seconds());
        long oldLifetime = SingletonEstimatorUtils.ESTIMATOR_UTILS.relativeLifetime(effectiveNow, account == null ? 0L : account.expirationSecond());
        long rbsDelta = SingletonEstimatorUtils.ESTIMATOR_UTILS.changeInBsUsage(CryptoUpdateHandler.cryptoAutoRenewRb(account), oldLifetime, sharedFixedBytes + newVariableBytes, newLifetime);
        long oldSlotsUsage = (long)(account == null ? 0 : account.maxAutoAssociations()) * 24000L;
        long newSlotsUsage = op.hasMaxAutomaticTokenAssociations() && !unlimitedAutoAssoc ? op.maxAutomaticTokenAssociations().longValue() * 24000L : oldSlotsUsage;
        long slotRbsDelta = SingletonEstimatorUtils.ESTIMATOR_UTILS.changeInBsUsage(oldSlotsUsage, Math.max(explicitAutoAssocSlotLifetime, oldLifetime), newSlotsUsage, Math.max(explicitAutoAssocSlotLifetime, newLifetime));
        FeeCalculator fees = feeCalculator.addBytesPerTransaction(baseSize).addRamByteSeconds(rbsDelta > 0L ? rbsDelta : 0L).addRamByteSeconds(slotRbsDelta > 0L ? slotRbsDelta : 0L);
        if (!op.hookCreationDetails().isEmpty() || !op.hookIdsToDelete().isEmpty()) {
            fees.addStorageBytesSeconds((long)(op.hookCreationDetails().size() + op.hookIdsToDelete().size()) * 3600L);
        }
        return fees.calculate();
    }
}

