/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.snapshot;

import com.hedera.hapi.node.base.SemanticVersion;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.StreamDebugUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.platform.state.service.schemas.V0540PlatformStateSchema;
import com.swirlds.platform.state.service.schemas.V0540RosterBaseSchema;
import com.swirlds.platform.state.signed.SigSet;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.state.snapshot.DeserializedSignedState;
import com.swirlds.platform.state.snapshot.SignedStateFileUtils;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.StateLifecycleManager;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Objects;
import org.hiero.consensus.crypto.ConsensusCryptoUtils;

public final class SignedStateFileReader {
    private SignedStateFileReader() {
    }

    @NonNull
    public static DeserializedSignedState readState(@NonNull Path stateDir, @NonNull PlatformContext platformContext, @NonNull StateLifecycleManager stateLifecycleManager) throws IOException {
        Objects.requireNonNull(stateDir);
        Objects.requireNonNull(platformContext);
        Configuration conf = platformContext.getConfiguration();
        SignedStateFileReader.checkSignedStateFilePath(stateDir);
        MerkleNodeState merkleNodeState = stateLifecycleManager.loadSnapshot(stateDir);
        File sigSetFile = stateDir.resolve("signatureSet.bin").toFile();
        SigSet sigSet = (SigSet)StreamDebugUtils.deserializeAndDebugOnFailure(() -> new BufferedInputStream(new FileInputStream(sigSetFile)), in -> {
            SignedStateFileReader.readAndCheckSigSetFileVersion(in);
            return (SigSet)in.readSerializable();
        });
        SignedState newSignedState = new SignedState(conf, ConsensusCryptoUtils::verifySignature, merkleNodeState, "SignedStateFileReader.readState()", false, false, false);
        SignedStateFileReader.registerServiceStates(newSignedState);
        newSignedState.setSigSet(sigSet);
        DeserializedSignedState returnState = new DeserializedSignedState(newSignedState.reserve("SignedStateFileReader.readState()"), merkleNodeState.getHash());
        return returnState;
    }

    private static void checkSignedStateFilePath(@NonNull Path stateDirectory) throws IOException {
        Path signedStateFilePath = stateDirectory.resolve("signatureSet.bin");
        if (!Files.exists(signedStateFilePath, new LinkOption[0])) {
            throw new IOException("Directory " + String.valueOf(signedStateFilePath.toAbsolutePath()) + " does not exist!");
        }
        if (!Files.isRegularFile(signedStateFilePath, new LinkOption[0])) {
            throw new IOException("File " + String.valueOf(signedStateFilePath.toAbsolutePath()) + " is not a file!");
        }
    }

    private static void readAndCheckSigSetFileVersion(@NonNull MerkleDataInputStream in) throws IOException {
        int fileVersion = in.readInt();
        if (!SignedStateFileUtils.SUPPORTED_SIGSET_VERSIONS.contains(fileVersion)) {
            throw new IOException("Unsupported file version: " + fileVersion);
        }
        in.readProtocolVersion();
    }

    public static void registerServiceStates(@NonNull SignedState signedState) {
        SignedStateFileReader.registerServiceStates(signedState.getState());
    }

    public static void registerServiceStates(@NonNull MerkleNodeState state) {
        SignedStateFileReader.registerServiceState(state, new V0540PlatformStateSchema(), "PlatformStateService");
        SignedStateFileReader.registerServiceState(state, new V0540RosterBaseSchema(), "RosterService");
    }

    private static void registerServiceState(@NonNull MerkleNodeState state, @NonNull Schema<SemanticVersion> schema, @NonNull String name) {
        schema.statesToCreate().stream().sorted(Comparator.comparing(StateDefinition::stateKey)).forEach(def -> {
            StateMetadata md = new StateMetadata(name, def);
            if (!def.singleton() && !def.onDisk()) {
                throw new IllegalStateException("Only singletons and onDisk virtual maps are supported as stub states");
            }
            state.initializeState(md);
        });
    }
}

