/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.OverflowException;
import org.hyperledger.besu.evm.internal.UnderflowException;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class ExtCodeSizeOperation
extends AbstractOperation {
    static final Bytes EOF_SIZE = Bytes.of((int[])new int[]{2});
    private final boolean enableEIP3540;

    public ExtCodeSizeOperation(GasCalculator gasCalculator) {
        this(gasCalculator, false);
    }

    public ExtCodeSizeOperation(GasCalculator gasCalculator, boolean enableEIP3540) {
        super(59, "EXTCODESIZE", 1, 1, gasCalculator);
        this.enableEIP3540 = enableEIP3540;
    }

    protected long cost(boolean accountIsWarm) {
        return this.gasCalculator().getExtCodeSizeOperationGasCost() + (accountIsWarm ? this.gasCalculator().getWarmStorageReadCost() : this.gasCalculator().getColdAccountAccessCost());
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        try {
            Bytes codeSize;
            Address address = Words.toAddress(frame.popStackItem());
            boolean accountIsWarm = frame.warmUpAddress(address) || this.gasCalculator().isPrecompile(address);
            long cost = this.cost(accountIsWarm);
            if (frame.getRemainingGas() < cost) {
                return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
            }
            Account account = frame.getWorldUpdater().get(address);
            if (account == null) {
                codeSize = Bytes.EMPTY;
            } else {
                Bytes code = account.getCode();
                codeSize = this.enableEIP3540 && code.size() >= 2 && code.get(0) == -17 && code.get(1) == 0 ? EOF_SIZE : Words.intBytes(code.size());
            }
            frame.pushStackItem(codeSize);
            return new Operation.OperationResult(cost, null);
        }
        catch (UnderflowException ufe) {
            return new Operation.OperationResult(this.cost(true), ExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS);
        }
        catch (OverflowException ofe) {
            return new Operation.OperationResult(this.cost(true), ExceptionalHaltReason.TOO_MANY_STACK_ITEMS);
        }
    }
}

