/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks;

import com.hedera.node.app.blocks.BlockItemWriter;
import com.hedera.node.app.blocks.BlockStreamManager;
import com.hedera.node.app.blocks.impl.BlockStreamManagerImpl;
import com.hedera.node.app.blocks.impl.BoundaryStateChangeListener;
import com.hedera.node.app.blocks.impl.streaming.BlockBufferService;
import com.hedera.node.app.blocks.impl.streaming.BlockNodeConnectionManager;
import com.hedera.node.app.blocks.impl.streaming.FileAndGrpcBlockItemWriter;
import com.hedera.node.app.blocks.impl.streaming.FileBlockItemWriter;
import com.hedera.node.app.blocks.impl.streaming.GrpcBlockItemWriter;
import com.hedera.node.app.metrics.BlockStreamMetrics;
import com.hedera.node.app.services.NodeFeeManager;
import com.hedera.node.app.services.NodeRewardManager;
import com.hedera.node.app.spi.records.SelfNodeAccountIdManager;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.BlockStreamConfig;
import com.hedera.node.config.types.BlockStreamWriterMode;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.state.State;
import dagger.Module;
import dagger.Provides;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.file.FileSystem;
import java.util.function.Supplier;
import javax.inject.Singleton;

@Module
public interface BlockStreamModule {
    @Provides
    @Singleton
    public static BlockBufferService provideBlockBufferService(@NonNull ConfigProvider configProvider, @NonNull BlockStreamMetrics blockStreamMetrics) {
        return new BlockBufferService(configProvider, blockStreamMetrics);
    }

    @Provides
    @Singleton
    public static BlockNodeConnectionManager provideBlockNodeConnectionManager(@NonNull ConfigProvider configProvider, @NonNull BlockBufferService blockBufferService, @NonNull BlockStreamMetrics blockStreamMetrics) {
        BlockNodeConnectionManager manager = new BlockNodeConnectionManager(configProvider, blockBufferService, blockStreamMetrics);
        blockBufferService.setBlockNodeConnectionManager(manager);
        manager.start();
        return manager;
    }

    @Provides
    @Singleton
    public static BlockStreamMetrics provideBlockStreamMetrics(@NonNull Metrics metrics) {
        return new BlockStreamMetrics(metrics);
    }

    @Provides
    @Singleton
    public static BlockStreamManager provideBlockStreamManager(@NonNull BlockStreamManagerImpl impl) {
        return impl;
    }

    @Provides
    @Singleton
    public static Supplier<BlockItemWriter> bindBlockItemWriterSupplier(@NonNull ConfigProvider configProvider, @NonNull SelfNodeAccountIdManager selfNodeAccountIdManager, @NonNull FileSystem fileSystem, @NonNull BlockBufferService blockBufferService, @NonNull BlockNodeConnectionManager blockNodeConnectionManager) {
        VersionedConfiguration config = configProvider.getConfiguration();
        BlockStreamConfig blockStreamConfig = (BlockStreamConfig)config.getConfigData(BlockStreamConfig.class);
        return switch (blockStreamConfig.writerMode()) {
            default -> throw new MatchException(null, null);
            case BlockStreamWriterMode.FILE -> () -> new FileBlockItemWriter(configProvider, selfNodeAccountIdManager, fileSystem);
            case BlockStreamWriterMode.GRPC -> () -> new GrpcBlockItemWriter(blockBufferService, blockNodeConnectionManager);
            case BlockStreamWriterMode.FILE_AND_GRPC -> () -> new FileAndGrpcBlockItemWriter(configProvider, selfNodeAccountIdManager, fileSystem, blockBufferService, blockNodeConnectionManager);
        };
    }

    @Provides
    @Singleton
    public static BlockStreamManager.Lifecycle provideBlockStreamManagerLifecycle(final @NonNull NodeRewardManager nodeRewardManager, final @NonNull BoundaryStateChangeListener listener, final @NonNull NodeFeeManager nodeFeeManager) {
        return new BlockStreamManager.Lifecycle(){

            @Override
            public void onOpenBlock(@NonNull State state) {
                nodeFeeManager.onOpenBlock(state);
                listener.resetCollectedNodeFees();
                nodeRewardManager.onOpenBlock(state);
            }

            @Override
            public void onCloseBlock(@NonNull State state) {
                nodeFeeManager.onCloseBlock(state);
                nodeRewardManager.onCloseBlock(state, listener.nodeFeesCollected());
            }
        };
    }
}

