/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl;

import com.hedera.hapi.block.stream.BlockItem;
import com.hedera.hapi.block.stream.output.CallContractOutput;
import com.hedera.hapi.block.stream.output.CreateAccountOutput;
import com.hedera.hapi.block.stream.output.CreateContractOutput;
import com.hedera.hapi.block.stream.output.CreateScheduleOutput;
import com.hedera.hapi.block.stream.output.EthereumOutput;
import com.hedera.hapi.block.stream.output.SignScheduleOutput;
import com.hedera.hapi.block.stream.output.StateChange;
import com.hedera.hapi.block.stream.output.StateChanges;
import com.hedera.hapi.block.stream.output.StateIdentifier;
import com.hedera.hapi.block.stream.output.TransactionOutput;
import com.hedera.hapi.block.stream.output.TransactionResult;
import com.hedera.hapi.block.stream.output.UtilPrngOutput;
import com.hedera.hapi.block.stream.trace.ContractSlotUsage;
import com.hedera.hapi.block.stream.trace.EvmTraceData;
import com.hedera.hapi.block.stream.trace.EvmTransactionLog;
import com.hedera.hapi.block.stream.trace.ExecutedInitcode;
import com.hedera.hapi.block.stream.trace.SlotRead;
import com.hedera.hapi.block.stream.trace.SubmitMessageTraceData;
import com.hedera.hapi.block.stream.trace.TraceData;
import com.hedera.hapi.block.stream.trace.WrittenSlotKeys;
import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenAssociation;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.base.TopicID;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.contract.ContractFunctionResult;
import com.hedera.hapi.node.contract.ContractNonceInfo;
import com.hedera.hapi.node.contract.EvmTransactionResult;
import com.hedera.hapi.node.contract.InternalCallContext;
import com.hedera.hapi.node.state.contract.SlotKey;
import com.hedera.hapi.node.transaction.AssessedCustomFee;
import com.hedera.hapi.node.transaction.ExchangeRateSet;
import com.hedera.hapi.node.transaction.PendingAirdropRecord;
import com.hedera.hapi.node.transaction.SignedTransaction;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.node.transaction.TransactionRecord;
import com.hedera.hapi.streams.ContractAction;
import com.hedera.hapi.streams.ContractActions;
import com.hedera.hapi.streams.ContractBytecode;
import com.hedera.hapi.streams.ContractStateChanges;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.blocks.BlockItemsTranslator;
import com.hedera.node.app.blocks.impl.TranslationContext;
import com.hedera.node.app.blocks.impl.contexts.AirdropOpContext;
import com.hedera.node.app.blocks.impl.contexts.BaseOpContext;
import com.hedera.node.app.blocks.impl.contexts.ContractOpContext;
import com.hedera.node.app.blocks.impl.contexts.CryptoOpContext;
import com.hedera.node.app.blocks.impl.contexts.FileOpContext;
import com.hedera.node.app.blocks.impl.contexts.MintOpContext;
import com.hedera.node.app.blocks.impl.contexts.NodeOpContext;
import com.hedera.node.app.blocks.impl.contexts.ScheduleOpContext;
import com.hedera.node.app.blocks.impl.contexts.SubmitOpContext;
import com.hedera.node.app.blocks.impl.contexts.SupplyChangeOpContext;
import com.hedera.node.app.blocks.impl.contexts.TokenOpContext;
import com.hedera.node.app.blocks.impl.contexts.TopicOpContext;
import com.hedera.node.app.service.addressbook.impl.records.NodeCreateStreamBuilder;
import com.hedera.node.app.service.consensus.impl.records.ConsensusCreateTopicStreamBuilder;
import com.hedera.node.app.service.consensus.impl.records.ConsensusSubmitMessageStreamBuilder;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import com.hedera.node.app.service.contract.impl.records.ContractCreateStreamBuilder;
import com.hedera.node.app.service.contract.impl.records.ContractDeleteStreamBuilder;
import com.hedera.node.app.service.contract.impl.records.ContractOperationStreamBuilder;
import com.hedera.node.app.service.contract.impl.records.ContractUpdateStreamBuilder;
import com.hedera.node.app.service.contract.impl.records.EthereumTransactionStreamBuilder;
import com.hedera.node.app.service.contract.impl.state.WritableEvmHookStore;
import com.hedera.node.app.service.file.impl.records.CreateFileStreamBuilder;
import com.hedera.node.app.service.schedule.ScheduleStreamBuilder;
import com.hedera.node.app.service.token.api.FeeStreamBuilder;
import com.hedera.node.app.service.token.impl.comparator.TokenComparators;
import com.hedera.node.app.service.token.records.ChildStreamBuilder;
import com.hedera.node.app.service.token.records.CryptoCreateStreamBuilder;
import com.hedera.node.app.service.token.records.CryptoDeleteStreamBuilder;
import com.hedera.node.app.service.token.records.CryptoTransferStreamBuilder;
import com.hedera.node.app.service.token.records.CryptoUpdateStreamBuilder;
import com.hedera.node.app.service.token.records.GenesisAccountStreamBuilder;
import com.hedera.node.app.service.token.records.HookDispatchStreamBuilder;
import com.hedera.node.app.service.token.records.NodeStakeUpdateStreamBuilder;
import com.hedera.node.app.service.token.records.TokenAccountWipeStreamBuilder;
import com.hedera.node.app.service.token.records.TokenAirdropStreamBuilder;
import com.hedera.node.app.service.token.records.TokenBurnStreamBuilder;
import com.hedera.node.app.service.token.records.TokenCreateStreamBuilder;
import com.hedera.node.app.service.token.records.TokenMintStreamBuilder;
import com.hedera.node.app.service.token.records.TokenUpdateStreamBuilder;
import com.hedera.node.app.service.util.impl.records.PrngStreamBuilder;
import com.hedera.node.app.service.util.impl.records.ReplayableFeeStreamBuilder;
import com.hedera.node.app.spi.records.RecordSource;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockStreamBuilder
implements StreamBuilder,
ConsensusCreateTopicStreamBuilder,
ConsensusSubmitMessageStreamBuilder,
CreateFileStreamBuilder,
CryptoCreateStreamBuilder,
CryptoTransferStreamBuilder,
ChildStreamBuilder,
PrngStreamBuilder,
ScheduleStreamBuilder,
TokenMintStreamBuilder,
TokenBurnStreamBuilder,
TokenCreateStreamBuilder,
ContractCreateStreamBuilder,
ContractCallStreamBuilder,
ContractUpdateStreamBuilder,
EthereumTransactionStreamBuilder,
CryptoDeleteStreamBuilder,
TokenUpdateStreamBuilder,
NodeStakeUpdateStreamBuilder,
FeeStreamBuilder,
ContractDeleteStreamBuilder,
GenesisAccountStreamBuilder,
ContractOperationStreamBuilder,
TokenAccountWipeStreamBuilder,
CryptoUpdateStreamBuilder,
NodeCreateStreamBuilder,
TokenAirdropStreamBuilder,
ReplayableFeeStreamBuilder,
HookDispatchStreamBuilder {
    private static final Logger log = LogManager.getLogger(BlockStreamBuilder.class);
    private static final Comparator<TokenAssociation> TOKEN_ASSOCIATION_COMPARATOR = Comparator.comparingLong(a -> a.tokenIdOrThrow().tokenNum()).thenComparingLong(a -> a.accountIdOrThrow().accountNumOrThrow());
    private static final Comparator<PendingAirdropRecord> PENDING_AIRDROP_RECORD_COMPARATOR = Comparator.comparing(PendingAirdropRecord::pendingAirdropIdOrThrow, TokenComparators.PENDING_AIRDROP_ID_COMPARATOR);
    private SignedTransaction signedTx;
    @Nullable
    private Bytes serializedSignedTx;
    @Nullable
    private HederaFunctionality functionality;
    private ExchangeRateSet translationContextExchangeRates;
    private String memo;
    private TransactionID transactionId;
    private List<Long> serialNumbers = new LinkedList<Long>();
    private long newTotalSupply = 0L;
    private long nodeId;
    private FileID fileId;
    private TopicID topicId;
    private TokenID tokenId;
    private AccountID accountId;
    private ContractID contractId;
    private long sequenceNumber = 0L;
    private Bytes runningHash = Bytes.EMPTY;
    private long runningHashVersion = 0L;
    private List<PendingAirdropRecord> pendingAirdropRecords = Collections.emptyList();
    private Bytes evmAddress = Bytes.EMPTY;
    private final TransactionResult.Builder transactionResultBuilder = TransactionResult.newBuilder();
    private ResponseCodeEnum status = ResponseCodeEnum.OK;
    private Instant consensusNow;
    private TransferList transferList = TransferList.DEFAULT;
    private List<TokenTransferList> tokenTransferLists = new LinkedList<TokenTransferList>();
    private List<AssessedCustomFee> assessedCustomFees = new LinkedList<AssessedCustomFee>();
    private List<AccountAmount> paidStakingRewards = new LinkedList<AccountAmount>();
    private final List<TokenAssociation> automaticTokenAssociations = new LinkedList<TokenAssociation>();
    private Long nextHookId;
    private ContractOpType contractOpType = null;
    @Nullable
    private EvmTransactionResult evmTransactionResult;
    @Nullable
    private Long senderNonce;
    @Nullable
    private List<ContractNonceInfo> changedNonceInfos;
    @Nullable
    private List<ContractID> createdContractIds;
    @Nullable
    private List<EvmTransactionLog> logs;
    @Nullable
    private List<ContractSlotUsage> slotUsages;
    @Nullable
    private List<ContractAction> contractActions;
    @Nullable
    private ExecutedInitcode initcode;
    private Bytes ethereumHash = Bytes.EMPTY;
    private boolean createsOrDeletesSchedule;
    private TransactionID scheduledTransactionId;
    private BlockItem utilPrngOutputItem;
    private ScheduleID scheduleId;
    @Nullable
    private Predicate<Object> logicallyIdentical;
    private final List<StateChange> stateChanges = new ArrayList<StateChange>();
    @Nullable
    private Set<AccountID> explicitRewardReceiverIds;
    private final Map<AccountID, AccountID> deletedAccountBeneficiaries = new HashMap<AccountID, AccountID>();
    private long transactionFee;
    private final HandleContext.TransactionCategory category;
    private final StreamBuilder.ReversingBehavior reversingBehavior;
    private final StreamBuilder.SignedTxCustomizer customizer;
    private boolean isContractCreate;
    private int deltaStorageSlotsUpdated;

    public BlockStreamBuilder(@NonNull StreamBuilder.ReversingBehavior reversingBehavior, @NonNull StreamBuilder.SignedTxCustomizer customizer, @NonNull HandleContext.TransactionCategory category) {
        this.reversingBehavior = Objects.requireNonNull(reversingBehavior);
        this.customizer = Objects.requireNonNull(customizer);
        this.category = Objects.requireNonNull(category);
    }

    public Output build(boolean topLevel, @Nullable List<StateChange> groupStateChanges) {
        EvmTraceData.Builder builder;
        ArrayList<BlockItem> blockItems = new ArrayList<BlockItem>();
        TranslationContext translationContext = this.translationContext();
        if (this.category != HandleContext.TransactionCategory.BATCH_INNER) {
            if (this.customizer != null) {
                this.signedTx = (SignedTransaction)this.customizer.apply((Object)this.signedTx);
                this.serializedSignedTx = null;
            }
            if (this.serializedSignedTx == null) {
                this.serializedSignedTx = SignedTransaction.PROTOBUF.toBytes((Object)this.signedTx);
            }
            blockItems.add(BlockItem.newBuilder().signedTransaction(this.serializedSignedTx).build());
        }
        blockItems.add(this.transactionResultBlockItem());
        this.addOutputItemsTo(blockItems);
        if (this.slotUsages != null || this.contractActions != null || this.initcode != null || this.logs != null) {
            builder = EvmTraceData.newBuilder();
            if (this.slotUsages != null) {
                boolean traceExplicitWrites;
                boolean bl = traceExplicitWrites = this.logicallyIdentical == null;
                if (traceExplicitWrites) {
                    if (this.status == ResponseCodeEnum.REVERTED_SUCCESS) {
                        this.slotUsages = this.slotUsages.stream().map(usage -> {
                            List writtenKeys = usage.writtenSlotKeysOrElse(WrittenSlotKeys.DEFAULT).keys();
                            ArrayList<SlotRead> reads = usage.slotReads();
                            if (!writtenKeys.isEmpty()) {
                                ArrayList<SlotRead> explicitReads = new ArrayList<SlotRead>(reads.size());
                                for (SlotRead read : reads) {
                                    if (read.hasIndex()) {
                                        explicitReads.add(read.copyBuilder().key((Bytes)writtenKeys.get(read.indexOrThrow())).build());
                                        continue;
                                    }
                                    explicitReads.add(read);
                                }
                                reads = explicitReads;
                            }
                            return usage.copyBuilder().slotReads((List)reads).writtenSlotKeys((WrittenSlotKeys)null).build();
                        }).toList();
                    }
                    builder.contractSlotUsages(this.slotUsages);
                } else {
                    HashMap<ContractID, Map> implicitWriteIndexes = new HashMap<ContractID, Map>();
                    List<StateChange> relevantStateChanges = groupStateChanges != null ? groupStateChanges : this.stateChanges;
                    for (StateChange stateChange : relevantStateChanges) {
                        Map indexes;
                        SlotKey slotKey;
                        if (stateChange.stateId() == StateIdentifier.STATE_ID_STORAGE.protoOrdinal()) {
                            slotKey = null;
                            if (stateChange.hasMapUpdate() && !stateChange.mapUpdateOrThrow().identical()) {
                                slotKey = stateChange.mapUpdateOrThrow().keyOrThrow().slotKeyKeyOrThrow();
                            } else if (stateChange.hasMapDelete()) {
                                slotKey = stateChange.mapDeleteOrThrow().keyOrThrow().slotKeyKeyOrThrow();
                            }
                            if (slotKey == null) continue;
                            indexes = implicitWriteIndexes.computeIfAbsent(slotKey.contractID(), k -> new HashMap());
                            indexes.put(slotKey.key(), indexes.size());
                            continue;
                        }
                        if (stateChange.stateId() != StateIdentifier.STATE_ID_EVM_HOOK_STORAGE.protoOrdinal()) continue;
                        slotKey = null;
                        if (stateChange.hasMapUpdate() && !stateChange.mapUpdateOrThrow().identical()) {
                            slotKey = new SlotKey(ContractID.DEFAULT, stateChange.mapUpdateOrThrow().keyOrThrow().evmHookSlotKeyOrThrow().key());
                        } else if (stateChange.hasMapDelete()) {
                            slotKey = new SlotKey(ContractID.DEFAULT, stateChange.mapDeleteOrThrow().keyOrThrow().evmHookSlotKeyOrThrow().key());
                        }
                        if (slotKey == null) continue;
                        indexes = implicitWriteIndexes.computeIfAbsent(slotKey.contractID(), k -> new HashMap());
                        indexes.put(slotKey.key(), indexes.size());
                    }
                    ArrayList<ContractSlotUsage> indexedSlotUsages = new ArrayList<ContractSlotUsage>(this.slotUsages.size());
                    for (ContractSlotUsage slotUsage : this.slotUsages) {
                        Map writeIndexes;
                        List reads = slotUsage.slotReads();
                        if (reads.isEmpty()) {
                            indexedSlotUsages.add(slotUsage);
                            continue;
                        }
                        ContractID contractId = slotUsage.contractIdOrThrow();
                        if (contractId.contractNumOrThrow() == 365L) {
                            contractId = ContractID.DEFAULT;
                        }
                        if ((writeIndexes = (Map)implicitWriteIndexes.get(contractId)) != null) {
                            ArrayList<SlotRead> indexedReads = new ArrayList<SlotRead>(reads.size());
                            for (SlotRead read : reads) {
                                Integer index;
                                Bytes key = read.keyOrThrow();
                                if (contractId == ContractID.DEFAULT) {
                                    key = WritableEvmHookStore.minimalKey((Bytes)key);
                                }
                                if ((index = (Integer)writeIndexes.get(key)) != null) {
                                    indexedReads.add(new SlotRead(new OneOf((Enum)SlotRead.IdentifierOneOfType.INDEX, (Object)index), read.readValue()));
                                    continue;
                                }
                                indexedReads.add(read);
                            }
                            indexedSlotUsages.add(new ContractSlotUsage(slotUsage.contractIdOrThrow(), null, indexedReads));
                            continue;
                        }
                        indexedSlotUsages.add(slotUsage);
                    }
                    builder.contractSlotUsages(indexedSlotUsages);
                }
            }
            if (this.contractActions != null) {
                builder.contractActions(this.contractActions);
            }
            if (this.initcode != null && !topLevel) {
                builder.executedInitcode(this.initcode);
            }
            if (this.logs != null) {
                builder.logs(this.logs);
            }
            blockItems.add(BlockItem.newBuilder().traceData(TraceData.newBuilder().evmTraceData(builder)).build());
        }
        if (groupStateChanges != null && (this.sequenceNumber > 0L || this.runningHash != Bytes.EMPTY)) {
            builder = SubmitMessageTraceData.newBuilder().sequenceNumber(this.sequenceNumber).runningHash(this.runningHash);
            blockItems.add(BlockItem.newBuilder().traceData(TraceData.newBuilder().submitMessageTraceData((SubmitMessageTraceData.Builder)builder)).build());
        }
        if (!this.stateChanges.isEmpty() || topLevel) {
            blockItems.add(BlockItem.newBuilder().stateChanges(StateChanges.newBuilder().consensusTimestamp(HapiUtils.asTimestamp((Instant)this.consensusNow)).stateChanges(this.stateChanges).build()).build());
        }
        return new Output(blockItems, translationContext);
    }

    public StreamBuilder stateChanges(@NonNull List<StateChange> stateChanges) {
        this.stateChanges.addAll(stateChanges);
        return this;
    }

    public List<StateChange> getStateChanges() {
        return this.stateChanges;
    }

    public ContractOperationStreamBuilder testForIdenticalKeys(@NonNull Predicate<Object> test) {
        this.logicallyIdentical = Objects.requireNonNull(test);
        return this;
    }

    @Nullable
    public Predicate<Object> logicallyIdenticalValueTest() {
        return this.logicallyIdentical;
    }

    public BlockStreamBuilder functionality(@NonNull HederaFunctionality functionality) {
        this.functionality = Objects.requireNonNull(functionality);
        return this;
    }

    @NonNull
    public StreamBuilder.ReversingBehavior reversingBehavior() {
        return this.reversingBehavior;
    }

    public int getNumAutoAssociations() {
        return this.automaticTokenAssociations.size();
    }

    public HederaFunctionality functionality() {
        return this.functionality;
    }

    public ScheduleID scheduleID() {
        return this.scheduleId;
    }

    @NonNull
    public BlockStreamBuilder parentConsensus(@NonNull Instant parentConsensus) {
        this.transactionResultBuilder.parentConsensusTimestamp(Timestamp.newBuilder().seconds(parentConsensus.getEpochSecond()).nanos(parentConsensus.getNano()).build());
        return this;
    }

    public StreamBuilder triggeringParentConsensus(@NonNull Instant at) {
        return this.parentConsensus(at);
    }

    @NonNull
    public BlockStreamBuilder consensusTimestamp(@NonNull Instant now) {
        this.consensusNow = Objects.requireNonNull(now, "consensus time must not be null");
        this.transactionResultBuilder.consensusTimestamp(Timestamp.newBuilder().seconds(now.getEpochSecond()).nanos(now.getNano()).build());
        return this;
    }

    @NonNull
    public BlockStreamBuilder signedTx(@NonNull SignedTransaction signedTx) {
        this.signedTx = Objects.requireNonNull(signedTx);
        return this;
    }

    public BlockStreamBuilder serializedSignedTx(@Nullable Bytes serializedSignedTx) {
        this.serializedSignedTx = serializedSignedTx;
        return this;
    }

    @NonNull
    public TransactionID transactionID() {
        return this.transactionId;
    }

    @NonNull
    public BlockStreamBuilder transactionID(@NonNull TransactionID transactionId) {
        this.transactionId = Objects.requireNonNull(transactionId);
        return this;
    }

    @NonNull
    public BlockStreamBuilder syncBodyIdFromRecordId() {
        this.signedTx = StreamBuilder.signedTxWith((TransactionBody)this.inProgressBody().copyBuilder().transactionID(this.transactionId).build());
        return this;
    }

    @NonNull
    public BlockStreamBuilder memo(@NonNull String memo) {
        this.memo = Objects.requireNonNull(memo);
        return this;
    }

    public long transactionFee() {
        return this.transactionFee;
    }

    @NonNull
    public BlockStreamBuilder transactionFee(long transactionFee) {
        this.transactionResultBuilder.transactionFeeCharged(transactionFee);
        this.transactionFee = transactionFee;
        return this;
    }

    public void trackExplicitRewardSituation(@NonNull AccountID accountId) {
        if (this.explicitRewardReceiverIds == null) {
            this.explicitRewardReceiverIds = new LinkedHashSet<AccountID>();
        }
        this.explicitRewardReceiverIds.add(accountId);
    }

    public Set<AccountID> explicitRewardSituationIds() {
        return this.explicitRewardReceiverIds != null ? this.explicitRewardReceiverIds : Collections.emptySet();
    }

    @NonNull
    public BlockStreamBuilder contractCallResult(@Nullable ContractFunctionResult contractCallResult) {
        throw new UnsupportedOperationException("Use concise EVM transaction result");
    }

    @NonNull
    public EthereumTransactionStreamBuilder newSenderNonce(long senderNonce) {
        this.senderNonce = senderNonce;
        return this;
    }

    @NonNull
    public BlockStreamBuilder changedNonceInfo(@NonNull List<ContractNonceInfo> nonceInfos) {
        this.changedNonceInfos = Objects.requireNonNull(nonceInfos);
        return this;
    }

    @NonNull
    public ContractOperationStreamBuilder createdContractIds(@NonNull List<ContractID> contractIds) {
        this.createdContractIds = Objects.requireNonNull(contractIds);
        return this;
    }

    @NonNull
    public BlockStreamBuilder evmCallTransactionResult(@Nullable EvmTransactionResult result) {
        this.evmTransactionResult = result;
        if (result != null) {
            this.contractOpType = this.contractOpType != ContractOpType.ETH_THROTTLED ? ContractOpType.CALL : ContractOpType.ETH_CALL;
        }
        return this;
    }

    @NonNull
    public ContractCallStreamBuilder addLogs(@NonNull List<EvmTransactionLog> logs) {
        this.logs = Objects.requireNonNull(logs);
        return this;
    }

    @NonNull
    public BlockStreamBuilder contractCreateResult(@Nullable ContractFunctionResult contractCreateResult) {
        throw new UnsupportedOperationException("Use concise EVM transaction result");
    }

    @NonNull
    public ContractCreateStreamBuilder evmCreateTransactionResult(@Nullable EvmTransactionResult result) {
        this.evmTransactionResult = result;
        if (result != null) {
            this.contractOpType = this.contractOpType != ContractOpType.ETH_THROTTLED ? ContractOpType.CREATE : ContractOpType.ETH_CREATE;
        }
        return this;
    }

    @NonNull
    public TransferList transferList() {
        return this.transferList;
    }

    @NonNull
    public BlockStreamBuilder transferList(@Nullable TransferList transferList) {
        this.transferList = transferList;
        return this;
    }

    public void setReplayedFees(@NonNull TransferList transferList) {
        Objects.requireNonNull(transferList);
        if (this.transferList != null && this.transferList != TransferList.DEFAULT) {
            throw new IllegalStateException("Transfer list already set");
        }
        this.transferList = transferList;
    }

    @NonNull
    public BlockStreamBuilder tokenTransferLists(@NonNull List<TokenTransferList> tokenTransferLists) {
        this.tokenTransferLists = Objects.requireNonNull(tokenTransferLists);
        this.transactionResultBuilder.tokenTransferLists(tokenTransferLists);
        return this;
    }

    public List<TokenTransferList> tokenTransferLists() {
        return this.tokenTransferLists;
    }

    @NonNull
    public BlockStreamBuilder tokenType(@NonNull TokenType tokenType) {
        return this;
    }

    public BlockStreamBuilder addPendingAirdrop(@NonNull PendingAirdropRecord pendingAirdropRecord) {
        Objects.requireNonNull(pendingAirdropRecord);
        if (this.pendingAirdropRecords.isEmpty()) {
            this.pendingAirdropRecords = new LinkedList<PendingAirdropRecord>();
        }
        this.pendingAirdropRecords.add(pendingAirdropRecord);
        return this;
    }

    @NonNull
    public BlockStreamBuilder scheduleRef(@NonNull ScheduleID scheduleRef) {
        Objects.requireNonNull(scheduleRef, "scheduleRef must not be null");
        this.transactionResultBuilder.scheduleRef(scheduleRef);
        return this;
    }

    @NonNull
    public BlockStreamBuilder assessedCustomFees(@NonNull List<AssessedCustomFee> assessedCustomFees) {
        this.assessedCustomFees = Objects.requireNonNull(assessedCustomFees);
        return this;
    }

    @NonNull
    public BlockStreamBuilder addAutomaticTokenAssociation(@NonNull TokenAssociation automaticTokenAssociation) {
        Objects.requireNonNull(automaticTokenAssociation, "automaticTokenAssociation must not be null");
        this.automaticTokenAssociations.add(automaticTokenAssociation);
        return this;
    }

    @NonNull
    public BlockStreamBuilder ethereumHash(@NonNull Bytes ethereumHash) {
        this.contractOpType = ContractOpType.ETH_THROTTLED;
        this.ethereumHash = Objects.requireNonNull(ethereumHash);
        return this;
    }

    @NonNull
    public BlockStreamBuilder paidStakingRewards(@NonNull List<AccountAmount> paidStakingRewards) {
        Objects.requireNonNull(paidStakingRewards);
        this.paidStakingRewards = paidStakingRewards;
        this.transactionResultBuilder.paidStakingRewards(paidStakingRewards);
        return this;
    }

    @NonNull
    public BlockStreamBuilder entropyNumber(int num) {
        this.utilPrngOutputItem = this.itemWith(TransactionOutput.newBuilder().utilPrng(UtilPrngOutput.newBuilder().prngNumber(num).build()));
        return this;
    }

    @NonNull
    public BlockStreamBuilder entropyBytes(@NonNull Bytes prngBytes) {
        Objects.requireNonNull(prngBytes);
        this.utilPrngOutputItem = this.itemWith(TransactionOutput.newBuilder().utilPrng(UtilPrngOutput.newBuilder().prngBytes(prngBytes).build()));
        return this;
    }

    @NonNull
    public BlockStreamBuilder evmAddress(@NonNull Bytes evmAddress) {
        this.evmAddress = Objects.requireNonNull(evmAddress);
        return this;
    }

    @NonNull
    public List<AssessedCustomFee> getAssessedCustomFees() {
        return this.assessedCustomFees;
    }

    @NonNull
    public BlockStreamBuilder status(@NonNull ResponseCodeEnum status) {
        this.status = Objects.requireNonNull(status);
        this.transactionResultBuilder.status(status);
        return this;
    }

    @NonNull
    public ResponseCodeEnum status() {
        return this.status;
    }

    public boolean hasContractResult() {
        return this.evmTransactionResult != null;
    }

    public long getGasUsedForContractTxn() {
        return Objects.requireNonNull(this.evmTransactionResult).gasUsed();
    }

    @NonNull
    public BlockStreamBuilder accountID(@Nullable AccountID accountID) {
        this.accountId = accountID;
        return this;
    }

    @NonNull
    public BlockStreamBuilder fileID(@NonNull FileID fileID) {
        this.fileId = fileID;
        return this;
    }

    @NonNull
    public BlockStreamBuilder contractID(@Nullable ContractID contractID) {
        this.contractId = contractID;
        this.accountId = null;
        return this;
    }

    @NonNull
    public BlockStreamBuilder createdContractID(@Nullable ContractID contractID) {
        this.isContractCreate = true;
        this.contractID(contractID);
        return this;
    }

    @NonNull
    public ContractCreateStreamBuilder createdEvmAddress(@Nullable Bytes evmAddress) {
        if (evmAddress != null) {
            this.evmAddress = Objects.requireNonNull(evmAddress);
        }
        return this;
    }

    @NonNull
    public BlockStreamBuilder exchangeRate(@Nullable ExchangeRateSet exchangeRate) {
        this.translationContextExchangeRates = exchangeRate;
        return this;
    }

    @NonNull
    public BlockStreamBuilder congestionMultiplier(long congestionMultiplier) {
        this.transactionResultBuilder.congestionPricingMultiplier(congestionMultiplier);
        return this;
    }

    @NonNull
    public BlockStreamBuilder topicID(@NonNull TopicID topicID) {
        this.topicId = Objects.requireNonNull(topicID);
        return this;
    }

    @NonNull
    public BlockStreamBuilder topicSequenceNumber(long topicSequenceNumber) {
        this.sequenceNumber = topicSequenceNumber;
        return this;
    }

    @NonNull
    public BlockStreamBuilder topicRunningHash(@NonNull Bytes topicRunningHash) {
        this.runningHash = Objects.requireNonNull(topicRunningHash);
        return this;
    }

    @NonNull
    public BlockStreamBuilder topicRunningHashVersion(long topicRunningHashVersion) {
        this.runningHashVersion = topicRunningHashVersion;
        return this;
    }

    @NonNull
    public BlockStreamBuilder tokenID(@NonNull TokenID tokenId) {
        this.tokenId = Objects.requireNonNull(tokenId);
        return this;
    }

    public TokenID tokenID() {
        return this.tokenId;
    }

    @NonNull
    public BlockStreamBuilder nodeID(long nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    @NonNull
    public BlockStreamBuilder newTotalSupply(long newTotalSupply) {
        this.newTotalSupply = newTotalSupply;
        return this;
    }

    public long getNewTotalSupply() {
        return this.newTotalSupply;
    }

    @NonNull
    public BlockStreamBuilder scheduleID(@NonNull ScheduleID scheduleID) {
        this.createsOrDeletesSchedule = true;
        this.scheduleId = Objects.requireNonNull(scheduleID);
        return this;
    }

    @NonNull
    public BlockStreamBuilder scheduledTransactionID(@NonNull TransactionID scheduledTransactionID) {
        this.scheduledTransactionId = Objects.requireNonNull(scheduledTransactionID);
        return this;
    }

    @NonNull
    public BlockStreamBuilder serialNumbers(@NonNull List<Long> serialNumbers) {
        Objects.requireNonNull(serialNumbers, "serialNumbers must not be null");
        this.serialNumbers = serialNumbers;
        return this;
    }

    @NonNull
    public List<Long> serialNumbers() {
        return this.serialNumbers;
    }

    @NonNull
    public BlockStreamBuilder addContractStateChanges(@NonNull ContractStateChanges contractStateChanges, boolean isMigration) {
        throw new UnsupportedOperationException("Add slot usages directly");
    }

    @NonNull
    public BlockStreamBuilder addContractSlotUsages(@NonNull List<ContractSlotUsage> slotUsages) {
        Objects.requireNonNull(slotUsages);
        this.slotUsages = slotUsages;
        return this;
    }

    @NonNull
    public BlockStreamBuilder addContractActions(@NonNull ContractActions contractActions, boolean isMigration) {
        throw new UnsupportedOperationException("Add actions directly");
    }

    @NonNull
    public BlockStreamBuilder addActions(@NonNull List<ContractAction> actions) {
        this.contractActions = Objects.requireNonNull(actions);
        return this;
    }

    @NonNull
    public BlockStreamBuilder addContractBytecode(@NonNull ContractBytecode contractBytecode, boolean isMigration) {
        throw new UnsupportedOperationException("Add initcode directly");
    }

    @NonNull
    public BlockStreamBuilder addInitcode(@NonNull ExecutedInitcode initcode) {
        Objects.requireNonNull(initcode);
        if (this.initcode != null) {
            log.warn("Overwriting existing initcode {} with new initcode {}", (Object)this.initcode, (Object)initcode);
        }
        this.initcode = initcode;
        return this;
    }

    public void addBeneficiaryForDeletedAccount(@NonNull AccountID deletedAccountID, @NonNull AccountID beneficiaryForDeletedAccount) {
        Objects.requireNonNull(deletedAccountID, "deletedAccountID must not be null");
        Objects.requireNonNull(beneficiaryForDeletedAccount, "beneficiaryForDeletedAccount must not be null");
        this.deletedAccountBeneficiaries.put(deletedAccountID, beneficiaryForDeletedAccount);
    }

    public int getNumberOfDeletedAccounts() {
        return this.deletedAccountBeneficiaries.size();
    }

    @Nullable
    public AccountID getDeletedAccountBeneficiaryFor(@NonNull AccountID deletedAccountID) {
        return this.deletedAccountBeneficiaries.get(deletedAccountID);
    }

    @NonNull
    public TransactionBody transactionBody() {
        return this.inProgressBody();
    }

    @NonNull
    public List<AccountAmount> getPaidStakingRewards() {
        return this.paidStakingRewards;
    }

    @NonNull
    public HandleContext.TransactionCategory category() {
        return this.category;
    }

    public void nextHookId(Long nextHookId) {
        this.nextHookId = nextHookId;
    }

    public Long getNextHookId() {
        return this.nextHookId;
    }

    public Bytes getEvmCallResult() {
        return Objects.requireNonNull(this.evmTransactionResult).resultData();
    }

    public int getDeltaStorageSlotsUpdated() {
        return this.deltaStorageSlotsUpdated;
    }

    public void setDeltaStorageSlotsUpdated(int deltaStorageSlotsUpdated) {
        this.deltaStorageSlotsUpdated = deltaStorageSlotsUpdated;
    }

    public void nullOutSideEffectFields() {
        this.serialNumbers.clear();
        if (!this.tokenTransferLists.isEmpty()) {
            this.tokenTransferLists.clear();
        }
        if (!this.pendingAirdropRecords.isEmpty()) {
            this.pendingAirdropRecords.clear();
        }
        this.automaticTokenAssociations.clear();
        this.transferList = TransferList.DEFAULT;
        this.paidStakingRewards.clear();
        this.assessedCustomFees.clear();
        this.newTotalSupply = 0L;
        this.transactionFee = 0L;
        this.accountId = null;
        if (this.isContractCreate) {
            this.contractId = null;
        }
        this.fileId = null;
        this.tokenId = null;
        this.topicId = null;
        this.nodeId = 0L;
        if (this.status != ResponseCodeEnum.IDENTICAL_SCHEDULE_ALREADY_CREATED) {
            this.scheduleId = null;
            this.scheduledTransactionId = null;
        }
        this.evmAddress = Bytes.EMPTY;
        this.runningHash = Bytes.EMPTY;
        this.sequenceNumber = 0L;
        this.runningHashVersion = 0L;
    }

    @NonNull
    private BlockItem transactionResultBlockItem() {
        if (!this.automaticTokenAssociations.isEmpty()) {
            this.automaticTokenAssociations.sort(TOKEN_ASSOCIATION_COMPARATOR);
            this.transactionResultBuilder.automaticTokenAssociations(this.automaticTokenAssociations);
        }
        if (!this.assessedCustomFees.isEmpty()) {
            this.transactionResultBuilder.assessedCustomFees(this.assessedCustomFees);
        }
        return BlockItem.newBuilder().transactionResult(this.transactionResultBuilder.transferList(this.transferList).build()).build();
    }

    private TransactionBody inProgressBody() {
        try {
            return (TransactionBody)TransactionBody.PROTOBUF.parse(this.signedTx.bodyBytes().toReadableSequentialData());
        }
        catch (Exception e) {
            throw new IllegalStateException("Record being built for unparseable transaction", e);
        }
    }

    private void addOutputItemsTo(@NonNull List<BlockItem> items) {
        if (this.utilPrngOutputItem != null) {
            items.add(this.utilPrngOutputItem);
        }
        if (this.evmTransactionResult != null || this.ethereumHash.length() > 0L) {
            TransactionOutput.Builder builder = TransactionOutput.newBuilder();
            switch (Objects.requireNonNull(this.contractOpType).ordinal()) {
                case 0: {
                    builder.contractCreate(CreateContractOutput.newBuilder().evmTransactionResult(this.evmTransactionResult).build());
                    break;
                }
                case 1: {
                    builder.contractCall(CallContractOutput.newBuilder().evmTransactionResult(this.evmTransactionResult).build());
                    break;
                }
                case 4: {
                    builder.ethereumCall(EthereumOutput.newBuilder().evmCallTransactionResult(this.ethEvmTransactionResult()).build());
                    break;
                }
                case 3: {
                    builder.ethereumCall(EthereumOutput.newBuilder().evmCreateTransactionResult(this.ethEvmTransactionResult()).build());
                    break;
                }
                case 2: {
                    builder.ethereumCall(EthereumOutput.DEFAULT);
                }
            }
            items.add(this.itemWith(builder));
        }
        if (this.createsOrDeletesSchedule && this.scheduledTransactionId != null) {
            items.add(this.itemWith(TransactionOutput.newBuilder().createSchedule(CreateScheduleOutput.newBuilder().scheduleId(this.scheduleId).scheduledTransactionId(this.scheduledTransactionId).build())));
        } else if (this.scheduledTransactionId != null) {
            items.add(this.itemWith(TransactionOutput.newBuilder().signSchedule(SignScheduleOutput.newBuilder().scheduledTransactionId(this.scheduledTransactionId).build())));
        }
        if (this.functionality == HederaFunctionality.CRYPTO_CREATE && this.accountId != null) {
            items.add(this.itemWith(TransactionOutput.newBuilder().accountCreate(CreateAccountOutput.newBuilder().createdAccountId(this.accountId).build())));
        }
    }

    @Nullable
    private EvmTransactionResult ethEvmTransactionResult() {
        if (this.evmTransactionResult == null) {
            return null;
        }
        if (!this.evmTransactionResult.hasInternalCallContext()) {
            return this.evmTransactionResult;
        }
        return this.evmTransactionResult.copyBuilder().internalCallContext((InternalCallContext)null).build();
    }

    private BlockItem itemWith(@NonNull TransactionOutput.Builder output) {
        return BlockItem.newBuilder().transactionOutput(output).build();
    }

    private TranslationContext translationContext() {
        return switch (Objects.requireNonNull(this.functionality)) {
            case HederaFunctionality.CONTRACT_CALL, HederaFunctionality.CONTRACT_CREATE, HederaFunctionality.CONTRACT_DELETE, HederaFunctionality.CONTRACT_UPDATE, HederaFunctionality.ETHEREUM_TRANSACTION -> new ContractOpContext(this.memo, this.translationContextExchangeRates, this.transactionId, this.signedTx, this.functionality, this.contractId, this.evmAddress.length() > 0L ? this.evmAddress : null, this.changedNonceInfos, this.createdContractIds, this.senderNonce, this.evmTransactionResult == null ? null : this.evmTransactionResult.internalCallContext(), this.ethereumHash, this.serializedSignedTx);
            case HederaFunctionality.CRYPTO_CREATE, HederaFunctionality.CRYPTO_UPDATE -> new CryptoOpContext(this.memo, this.translationContextExchangeRates, this.transactionId, this.signedTx, this.functionality, this.accountId, this.evmAddress, this.serializedSignedTx);
            case HederaFunctionality.FILE_CREATE -> new FileOpContext(this.memo, this.translationContextExchangeRates, this.transactionId, this.signedTx, this.functionality, this.fileId, this.serializedSignedTx);
            case HederaFunctionality.NODE_CREATE -> new NodeOpContext(this.memo, this.translationContextExchangeRates, this.transactionId, this.signedTx, this.functionality, this.nodeId, this.serializedSignedTx);
            case HederaFunctionality.SCHEDULE_DELETE -> new ScheduleOpContext(this.memo, this.translationContextExchangeRates, this.transactionId, this.signedTx, this.functionality, this.scheduleId, this.serializedSignedTx);
            case HederaFunctionality.CONSENSUS_SUBMIT_MESSAGE -> new SubmitOpContext(this.memo, this.translationContextExchangeRates, this.transactionId, this.signedTx, this.functionality, this.runningHash, this.runningHashVersion, this.sequenceNumber, this.serializedSignedTx);
            case HederaFunctionality.TOKEN_AIRDROP -> {
                if (!this.pendingAirdropRecords.isEmpty()) {
                    this.pendingAirdropRecords.sort(PENDING_AIRDROP_RECORD_COMPARATOR);
                }
                yield new AirdropOpContext(this.memo, this.translationContextExchangeRates, this.transactionId, this.signedTx, this.functionality, this.pendingAirdropRecords, this.serializedSignedTx);
            }
            case HederaFunctionality.TOKEN_MINT -> new MintOpContext(this.memo, this.translationContextExchangeRates, this.transactionId, this.signedTx, this.functionality, this.serialNumbers, this.newTotalSupply, this.serializedSignedTx);
            case HederaFunctionality.TOKEN_BURN, HederaFunctionality.TOKEN_ACCOUNT_WIPE -> new SupplyChangeOpContext(this.memo, this.translationContextExchangeRates, this.transactionId, this.signedTx, this.functionality, this.newTotalSupply, this.serializedSignedTx);
            case HederaFunctionality.TOKEN_CREATE -> new TokenOpContext(this.memo, this.translationContextExchangeRates, this.transactionId, this.signedTx, this.functionality, this.tokenId, this.serializedSignedTx);
            case HederaFunctionality.CONSENSUS_CREATE_TOPIC -> new TopicOpContext(this.memo, this.translationContextExchangeRates, this.transactionId, this.signedTx, this.functionality, this.topicId, this.serializedSignedTx);
            default -> new BaseOpContext(this.memo, this.translationContextExchangeRates, this.transactionId, this.signedTx, this.functionality, this.serializedSignedTx);
        };
    }

    private static enum ContractOpType {
        CREATE,
        CALL,
        ETH_THROTTLED,
        ETH_CREATE,
        ETH_CALL;

    }

    public record Output(@NonNull List<BlockItem> blockItems, @NonNull TranslationContext translationContext) {
        public Output {
            Objects.requireNonNull(blockItems);
            Objects.requireNonNull(translationContext);
        }

        public void forEachItem(@NonNull Consumer<BlockItem> action) {
            Objects.requireNonNull(action);
            this.blockItems.forEach(action);
        }

        public TransactionRecord toRecord(@NonNull BlockItemsTranslator translator) {
            Objects.requireNonNull(translator);
            return (TransactionRecord)this.toView(translator, View.RECORD);
        }

        public RecordSource.IdentifiedReceipt toIdentifiedReceipt(@NonNull BlockItemsTranslator translator) {
            Objects.requireNonNull(translator);
            return (RecordSource.IdentifiedReceipt)this.toView(translator, View.RECEIPT);
        }

        private <T> T toView(@NonNull BlockItemsTranslator translator, @NonNull View view) {
            int i = 0;
            int n = this.blockItems.size();
            TransactionResult result = null;
            while (i < n && (result = this.blockItems.get(i++).transactionResult()) == null) {
            }
            Objects.requireNonNull(result);
            if (i < n && this.blockItems.get(i).hasTransactionOutput()) {
                int j;
                for (j = i; j < n && this.blockItems.get(j).hasTransactionOutput(); ++j) {
                }
                TransactionOutput[] outputs = new TransactionOutput[j - i];
                for (int k = i; k < j; ++k) {
                    outputs[k - i] = this.blockItems.get(k).transactionOutput();
                }
                ArrayList logs = null;
                for (BlockItem item : this.blockItems.subList(j, n)) {
                    TraceData traceData;
                    if (!item.hasTraceData() || !(traceData = item.traceDataOrThrow()).hasEvmTraceData()) continue;
                    if (logs == null) {
                        logs = new ArrayList();
                    }
                    logs.addAll(traceData.evmTraceDataOrThrow().logs());
                }
                return (T)(switch (view.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> new RecordSource.IdentifiedReceipt(this.translationContext.txnId(), translator.translateReceipt(this.translationContext, result, outputs));
                    case 1 -> translator.translateRecord(this.translationContext, result, logs, outputs);
                });
            }
            return (T)(switch (view.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> new RecordSource.IdentifiedReceipt(this.translationContext.txnId(), translator.translateReceipt(this.translationContext, result, new TransactionOutput[0]));
                case 1 -> translator.translateRecord(this.translationContext, result, null, new TransactionOutput[0]);
            });
        }

        private static enum View {
            RECEIPT,
            RECORD;

        }
    }
}

