/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.types.Annotation;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.service.registry.CoreServiceRegistry;
import io.helidon.service.registry.Interception;
import io.helidon.service.registry.InterceptionContext;
import io.helidon.service.registry.InterceptionInvoker;
import io.helidon.service.registry.InterceptionMetadata;
import io.helidon.service.registry.Invocation;
import io.helidon.service.registry.Lookup;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.ServiceInfo;
import io.helidon.service.registry.ServiceManager;
import io.helidon.service.registry.ServiceSupplies;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

class InterceptionMetadataImpl
implements InterceptionMetadata {
    private static final ResolvedType ELEMENT_INTERCEPTOR = ResolvedType.create(Interception.ElementInterceptor.class);
    private final CoreServiceRegistry registry;

    private InterceptionMetadataImpl(CoreServiceRegistry registry) {
        this.registry = registry;
    }

    static InterceptionMetadata create(CoreServiceRegistry registry) {
        return new InterceptionMetadataImpl(registry);
    }

    static InterceptionMetadata noop() {
        return new NoopMetadata();
    }

    @Override
    public <T> InterceptionInvoker<T> createInvoker(ServiceInfo descriptor, Set<Qualifier> typeQualifiers, List<Annotation> typeAnnotations, TypedElementInfo element, InterceptionInvoker<T> targetInvoker, Set<Class<? extends Throwable>> checkedExceptions) {
        Objects.requireNonNull(descriptor);
        Objects.requireNonNull(typeQualifiers);
        Objects.requireNonNull(typeAnnotations);
        Objects.requireNonNull(element);
        Objects.requireNonNull(targetInvoker);
        Objects.requireNonNull(checkedExceptions);
        List<Supplier<Interception.Interceptor>> interceptors = this.interceptors(descriptor, typeAnnotations, element);
        if (interceptors.isEmpty()) {
            return targetInvoker;
        }
        return params -> Invocation.invokeInterception(((InterceptionContext.Builder)((InterceptionContext.Builder)((InterceptionContext.Builder)InterceptionContext.builder().serviceInfo(descriptor)).typeAnnotations(typeAnnotations)).elementInfo(element)).build(), interceptors, targetInvoker, params, checkedExceptions);
    }

    @Override
    public <T> InterceptionInvoker<T> createInvoker(Object serviceInstance, ServiceInfo descriptor, Set<Qualifier> typeQualifiers, List<Annotation> typeAnnotations, TypedElementInfo element, InterceptionInvoker<T> targetInvoker, Set<Class<? extends Throwable>> checkedExceptions) {
        Objects.requireNonNull(serviceInstance);
        Objects.requireNonNull(descriptor);
        Objects.requireNonNull(typeQualifiers);
        Objects.requireNonNull(typeAnnotations);
        Objects.requireNonNull(element);
        Objects.requireNonNull(targetInvoker);
        Objects.requireNonNull(checkedExceptions);
        List<Supplier<Interception.Interceptor>> interceptors = this.interceptors(descriptor, typeAnnotations, element);
        if (interceptors.isEmpty()) {
            return targetInvoker;
        }
        return params -> Invocation.invokeInterception(((InterceptionContext.Builder)((InterceptionContext.Builder)((InterceptionContext.Builder)((InterceptionContext.Builder)InterceptionContext.builder().serviceInstance(serviceInstance)).serviceInfo(descriptor)).typeAnnotations(typeAnnotations)).elementInfo(element)).build(), interceptors, targetInvoker, params, checkedExceptions);
    }

    private List<Supplier<Interception.Interceptor>> interceptors(ServiceInfo descriptor, List<Annotation> typeAnnotations, TypedElementInfo element) {
        List<ServiceManager<Interception.Interceptor>> allInterceptors = this.registry.interceptors();
        ArrayList<Supplier<Interception.Interceptor>> result = new ArrayList<Supplier<Interception.Interceptor>>();
        for (ServiceManager<Interception.Interceptor> interceptor : allInterceptors) {
            if (interceptor.descriptor().contracts().contains(ELEMENT_INTERCEPTOR)) {
                String elementSignature = descriptor.serviceType().fqName() + "." + element.signature().text();
                if (!this.applicableElement(elementSignature, interceptor.descriptor())) continue;
                result.add(new ServiceSupplies.ServiceSupply(Lookup.EMPTY, List.of(interceptor)));
                continue;
            }
            if (this.applicable(typeAnnotations, interceptor.descriptor())) {
                result.add(new ServiceSupplies.ServiceSupply(Lookup.EMPTY, List.of(interceptor)));
                continue;
            }
            if (!this.applicable(element.annotations(), interceptor.descriptor())) continue;
            result.add(new ServiceSupplies.ServiceSupply(Lookup.EMPTY, List.of(interceptor)));
        }
        return result;
    }

    private boolean applicableElement(String signature, ServiceInfo serviceInfo) {
        return serviceInfo.qualifiers().contains(Qualifier.createNamed(signature));
    }

    private boolean applicable(List<Annotation> typeAnnotations, ServiceInfo serviceInfo) {
        for (Annotation typeAnnotation : typeAnnotations) {
            if (!serviceInfo.qualifiers().contains(Qualifier.createNamed(typeAnnotation.typeName().fqName()))) continue;
            return true;
        }
        return false;
    }

    private static class NoopMetadata
    implements InterceptionMetadata {
        private NoopMetadata() {
        }

        @Override
        public <T> InterceptionInvoker<T> createInvoker(ServiceInfo descriptor, Set<Qualifier> typeQualifiers, List<Annotation> typeAnnotations, TypedElementInfo element, InterceptionInvoker<T> targetInvoker, Set<Class<? extends Throwable>> checkedExceptions) {
            Objects.requireNonNull(descriptor);
            Objects.requireNonNull(typeQualifiers);
            Objects.requireNonNull(typeAnnotations);
            Objects.requireNonNull(element);
            Objects.requireNonNull(targetInvoker);
            Objects.requireNonNull(checkedExceptions);
            return targetInvoker;
        }

        @Override
        public <T> InterceptionInvoker<T> createInvoker(Object serviceInstance, ServiceInfo descriptor, Set<Qualifier> typeQualifiers, List<Annotation> typeAnnotations, TypedElementInfo element, InterceptionInvoker<T> targetInvoker, Set<Class<? extends Throwable>> checkedExceptions) {
            Objects.requireNonNull(serviceInstance);
            Objects.requireNonNull(descriptor);
            Objects.requireNonNull(typeQualifiers);
            Objects.requireNonNull(typeAnnotations);
            Objects.requireNonNull(element);
            Objects.requireNonNull(targetInvoker);
            Objects.requireNonNull(checkedExceptions);
            return targetInvoker;
        }
    }
}

