/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.http.Header;
import io.helidon.http.Headers;
import io.helidon.http.ServerResponseHeaders;
import io.helidon.http.Status;

public class HttpException
extends RuntimeException {
    private final Status status;
    private final boolean keepAlive;
    private final ServerResponseHeaders headers = ServerResponseHeaders.create();

    public HttpException(String message) {
        this(message, Status.INTERNAL_SERVER_ERROR_500);
    }

    public HttpException(String message, Throwable cause) {
        this(message, Status.INTERNAL_SERVER_ERROR_500, cause);
    }

    public HttpException(String message, Status status) {
        this(message, status, null);
    }

    public HttpException(String message, Status status, boolean keepAlive) {
        this(message, status, null, keepAlive);
    }

    public HttpException(String message, Status status, Throwable cause) {
        this(message, status, cause, false);
    }

    public HttpException(String message, Status status, Throwable cause, boolean keepAlive) {
        super(message, cause);
        this.status = status;
        this.keepAlive = keepAlive;
    }

    public final Status status() {
        return this.status;
    }

    public boolean keepAlive() {
        return this.keepAlive;
    }

    public HttpException header(Header header) {
        this.headers.set(header);
        return this;
    }

    public Headers headers() {
        return this.headers;
    }
}

