/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.pces;

import com.hedera.hapi.platform.event.GossipEvent;
import com.swirlds.common.io.extendable.ExtendableOutputStream;
import com.swirlds.common.io.extendable.OutputStreamExtension;
import com.swirlds.common.io.extendable.extensions.CountingStreamExtension;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.SyncFailedException;
import java.nio.file.Path;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.consensus.pces.PcesFileWriter;

public class PcesOutputStreamFileWriter
implements PcesFileWriter {
    private final SerializableDataOutputStream out;
    private final FileDescriptor fileDescriptor;
    private final CountingStreamExtension counter = new CountingStreamExtension(false);

    public PcesOutputStreamFileWriter(@NonNull Path filePath) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(filePath.toFile());
        this.fileDescriptor = fileOutputStream.getFD();
        this.out = new SerializableDataOutputStream((OutputStream)new ExtendableOutputStream((OutputStream)new BufferedOutputStream(fileOutputStream), (OutputStreamExtension)this.counter));
    }

    @Override
    public void writeVersion(int version) throws IOException {
        this.out.writeInt(version);
    }

    @Override
    public long writeEvent(@NonNull GossipEvent event) throws IOException {
        return this.out.writePbjRecord((Object)event, GossipEvent.PROTOBUF);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void sync() throws IOException {
        this.out.flush();
        try {
            this.fileDescriptor.sync();
        }
        catch (SyncFailedException e) {
            throw new IOException("Failed to sync file", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public long fileSize() {
        return this.counter.getCount();
    }
}

