/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.cryptography.tss;

import com.hedera.cryptography.hints.HintsLibraryBridge;
import com.hedera.cryptography.wraps.WRAPSLibraryBridge;
import java.util.Arrays;

public final class TSS {
    private static final int HINTS_VERIFICATION_KEY_LENGTH = 1480;
    private static final int HINTS_SIGNATURE_LENGTH = 1632;
    private static final int COMPRESSED_WRAPS_PROOF_LENGTH = 704;
    private static final int AGGREGATE_SCHNORR_SIGNATURE_LENGTH = 64;
    private static final HintsLibraryBridge HINTS = HintsLibraryBridge.getInstance();
    private static final WRAPSLibraryBridge WRAPS = WRAPSLibraryBridge.getInstance();
    private static byte[][] schnorrPublicKeys;

    private TSS() {
    }

    public static byte[] composeSignature(byte[] hintsVerificationKey, byte[] hintsSignature, byte[] abProof) throws IllegalArgumentException {
        if (hintsVerificationKey == null || hintsVerificationKey.length != 1480) {
            throw new IllegalArgumentException("`hintsVerificationKey` must have a length of 1480");
        }
        if (hintsSignature == null || hintsSignature.length != 1632) {
            throw new IllegalArgumentException("`hintsSignature` must have a length of 1632");
        }
        if (abProof == null || abProof.length != 704 && abProof.length != 64) {
            throw new IllegalArgumentException("`abProof` must have a length of 704 or 64");
        }
        byte[] array = Arrays.copyOf(hintsVerificationKey, hintsVerificationKey.length + hintsSignature.length + abProof.length);
        System.arraycopy(hintsSignature, 0, array, hintsVerificationKey.length, hintsSignature.length);
        System.arraycopy(abProof, 0, array, hintsVerificationKey.length + hintsSignature.length, abProof.length);
        return array;
    }

    public static void setSchnorrPublicKeys(byte[][] schnorrPublicKeys) {
        TSS.schnorrPublicKeys = schnorrPublicKeys;
    }

    public static boolean verifyTSS(byte[] ledgerId, byte[] tssSignature, byte[] message) throws IllegalStateException, IllegalArgumentException {
        if (ledgerId == null || ledgerId.length != 32) {
            throw new IllegalArgumentException("`ledgerId` must be a 32 bytes array, instead got " + (ledgerId == null ? null : "" + ledgerId.length));
        }
        if (tssSignature == null || tssSignature.length <= 3112) {
            throw new IllegalArgumentException("`tssSignature` is too short. Expected more than 3112 bytes, instead got " + (tssSignature == null ? null : "" + tssSignature.length));
        }
        if (message == null || message.length == 0) {
            throw new IllegalArgumentException("`message` must be a non-empty array");
        }
        byte[] hintsVerificationKey = Arrays.copyOfRange(tssSignature, 0, 1480);
        byte[] abProof = Arrays.copyOfRange(tssSignature, 3112, tssSignature.length);
        if (abProof.length == 704) {
            if (!WRAPS.verifyCompressedProof(abProof, ledgerId, hintsVerificationKey)) {
                return false;
            }
        } else if (abProof.length == 64) {
            if (schnorrPublicKeys == null) {
                throw new IllegalStateException("Schnorr public keys haven't been provided");
            }
            byte[] hintsKeyHash = WRAPS.hashArray(hintsVerificationKey);
            if (hintsKeyHash == null) {
                throw new IllegalArgumentException("Failed to hash `hints_verification_key` from `tssSignature`");
            }
            byte[] rotationMessage = Arrays.copyOf(ledgerId, ledgerId.length + hintsKeyHash.length);
            System.arraycopy(hintsKeyHash, 0, rotationMessage, ledgerId.length, hintsKeyHash.length);
            if (!WRAPS.verifySignature(schnorrPublicKeys, rotationMessage, abProof)) {
                return false;
            }
        } else {
            throw new IllegalArgumentException("The AddressBook proof part of the `tssSignature` is neither a compressed WRAPS proof with length 704, nor an aggregate Schnorr signature with length 64. Instead, its length is " + abProof.length);
        }
        byte[] hintsSignature = Arrays.copyOfRange(tssSignature, 1480, 3112);
        return HINTS.verifyAggregate(hintsSignature, message, hintsVerificationKey);
    }
}

