/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.precompile;

import com.sun.jna.ptr.IntByReference;
import java.math.BigInteger;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.precompile.AbstractPrecompiledContract;
import org.hyperledger.besu.evm.precompile.PrecompiledContract;
import org.hyperledger.besu.nativelib.arithmetic.LibArithmetic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigIntegerModularExponentiationPrecompiledContract
extends AbstractPrecompiledContract {
    private static final Logger LOG = LoggerFactory.getLogger(BigIntegerModularExponentiationPrecompiledContract.class);
    static boolean useNative;
    public static final int BASE_OFFSET = 96;
    private static final int PARAMETER_LENGTH = 32;
    private static final int BASE_LENGTH_OFFSET = 0;
    private static final int EXPONENT_LENGTH_OFFSET = 32;
    private static final int MODULUS_LENGTH_OFFSET = 64;

    public BigIntegerModularExponentiationPrecompiledContract(GasCalculator gasCalculator) {
        super("BigIntModExp", gasCalculator);
    }

    public static void disableNative() {
        useNative = false;
    }

    public static boolean maybeEnableNative() {
        try {
            useNative = LibArithmetic.ENABLED;
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError ule) {
            LOG.info("modexp native precompile not available: {}", (Object)ule.getMessage());
            useNative = false;
        }
        return useNative;
    }

    public static boolean isNative() {
        return useNative;
    }

    @Override
    public long gasRequirement(Bytes input) {
        return this.gasCalculator().modExpGasCost(input);
    }

    @Override
    @Nonnull
    public PrecompiledContract.PrecompileContractResult computePrecompile(Bytes input, @Nonnull MessageFrame messageFrame) {
        if (useNative) {
            return this.computeNative(input);
        }
        return this.computeDefault(input);
    }

    @Nonnull
    public PrecompiledContract.PrecompileContractResult computeDefault(Bytes input) {
        int baseLength = Words.clampedToInt(BigIntegerModularExponentiationPrecompiledContract.baseLength(input));
        int exponentLength = Words.clampedToInt(BigIntegerModularExponentiationPrecompiledContract.exponentLength(input));
        int modulusLength = Words.clampedToInt(BigIntegerModularExponentiationPrecompiledContract.modulusLength(input));
        if (baseLength == 0 && modulusLength == 0) {
            return PrecompiledContract.PrecompileContractResult.success(Bytes.EMPTY);
        }
        int exponentOffset = 96 + baseLength;
        int modulusOffset = exponentOffset + exponentLength;
        BigInteger base = BigIntegerModularExponentiationPrecompiledContract.extractParameter(input, 96, baseLength);
        BigInteger exp = BigIntegerModularExponentiationPrecompiledContract.extractParameter(input, exponentOffset, exponentLength);
        BigInteger mod = BigIntegerModularExponentiationPrecompiledContract.extractParameter(input, modulusOffset, modulusLength);
        MutableBytes result = MutableBytes.create((int)modulusLength);
        Object modExp = mod.compareTo(BigInteger.ZERO) == 0 ? MutableBytes.EMPTY : Bytes.wrap((byte[])base.modPow(exp, mod).toByteArray()).trimLeadingZeros();
        modExp.copyTo(result, result.size() - modExp.size());
        return PrecompiledContract.PrecompileContractResult.success((Bytes)result);
    }

    public static long multiplicationComplexity(long x) {
        if (x <= 64L) {
            return BigIntegerModularExponentiationPrecompiledContract.square(x);
        }
        if (x <= 1024L) {
            return Words.clampedAdd(BigIntegerModularExponentiationPrecompiledContract.square(x) / 4L, Words.clampedMultiply(x, 96L)) - 3072L;
        }
        return Words.clampedAdd(BigIntegerModularExponentiationPrecompiledContract.square(x) / 16L, Words.clampedMultiply(480L, x)) - 199680L;
    }

    public static long baseLength(Bytes input) {
        return BigIntegerModularExponentiationPrecompiledContract.extractParameterLong(input, 0, 32);
    }

    public static long exponentLength(Bytes input) {
        return BigIntegerModularExponentiationPrecompiledContract.extractParameterLong(input, 32, 32);
    }

    public static long modulusLength(Bytes input) {
        return BigIntegerModularExponentiationPrecompiledContract.extractParameterLong(input, 64, 32);
    }

    public static BigInteger extractParameter(Bytes input, int offset, int length) {
        if (offset >= input.size() || length == 0) {
            return BigInteger.ZERO;
        }
        if (offset + length < input.size()) {
            return new BigInteger(1, input.slice(offset, length).toArray());
        }
        byte[] raw = new byte[length];
        Bytes partial = input.slice(offset);
        System.arraycopy(partial.toArray(), 0, raw, 0, partial.size());
        return new BigInteger(1, raw);
    }

    public static long extractParameterLong(Bytes input, int offset, int length) {
        Bytes num;
        if (offset >= input.size() || length == 0) {
            return 0L;
        }
        if (offset + length <= input.size()) {
            num = input.slice(offset, length).trimLeadingZeros();
        } else {
            MutableBytes mut = MutableBytes.create((int)length);
            input.slice(offset).copyTo(mut, 0);
            num = mut.trimLeadingZeros();
        }
        return Words.clampedToLong(num);
    }

    private static long square(long n) {
        return Words.clampedMultiply(n, n);
    }

    public PrecompiledContract.PrecompileContractResult computeNative(@Nonnull Bytes input) {
        int modulusLength = Words.clampedToInt(BigIntegerModularExponentiationPrecompiledContract.modulusLength(input));
        IntByReference o_len = new IntByReference(modulusLength);
        byte[] result = new byte[modulusLength];
        int errorNo = LibArithmetic.modexp_precompiled((byte[])input.toArrayUnsafe(), (int)input.size(), (byte[])result, (IntByReference)o_len);
        if (errorNo == 0) {
            return PrecompiledContract.PrecompileContractResult.success(Bytes.wrap((byte[])result, (int)0, (int)o_len.getValue()));
        }
        LOG.trace("Error executing precompiled contract {}: {}", (Object)this.getName(), (Object)errorNo);
        return PrecompiledContract.PrecompileContractResult.halt(null, Optional.of(ExceptionalHaltReason.PRECOMPILE_ERROR));
    }
}

