/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.communication;

import com.swirlds.base.time.Time;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.network.ConnectionManager;
import com.swirlds.platform.network.NetworkProtocolException;
import com.swirlds.platform.network.NetworkUtils;
import com.swirlds.platform.network.communication.NegotiationException;
import com.swirlds.platform.network.communication.NegotiationProtocols;
import com.swirlds.platform.network.communication.Negotiator;
import com.swirlds.platform.network.protocol.ProtocolRunnable;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import org.hiero.base.concurrent.interrupt.InterruptableRunnable;
import org.hiero.consensus.concurrent.utility.throttle.RateLimiter;

public class ProtocolNegotiatorThread
implements InterruptableRunnable {
    private static final Duration SOCKET_EXCEPTION_DURATION = Duration.ofMinutes(1L);
    private final int sleepMillis;
    private final ConnectionManager connectionManager;
    private final List<ProtocolRunnable> handshakeProtocols;
    private final NegotiationProtocols protocols;
    private final RateLimiter socketExceptionRateLimiter;

    public ProtocolNegotiatorThread(ConnectionManager connectionManager, int sleepMillis, List<ProtocolRunnable> handshakeProtocols, NegotiationProtocols protocols, Time time) {
        this.connectionManager = connectionManager;
        this.sleepMillis = sleepMillis;
        this.handshakeProtocols = handshakeProtocols;
        this.protocols = protocols;
        this.socketExceptionRateLimiter = new RateLimiter(time, SOCKET_EXCEPTION_DURATION);
    }

    public void run() throws InterruptedException {
        Connection currentConn = this.connectionManager.waitForConnection();
        Negotiator negotiator = new Negotiator(this.protocols, currentConn, this.sleepMillis);
        try {
            for (ProtocolRunnable handshakeProtocol : this.handshakeProtocols) {
                handshakeProtocol.runProtocol(currentConn);
            }
            while (currentConn.connected()) {
                negotiator.execute();
            }
        }
        catch (NetworkProtocolException | NegotiationException | IOException | RuntimeException e) {
            NetworkUtils.handleNetworkException(e, currentConn, this.socketExceptionRateLimiter);
        }
    }
}

