/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.Weight;
import io.helidon.http.Headers__ServiceDescriptor;
import io.helidon.http.HttpPrologue__ServiceDescriptor;
import io.helidon.http.ServerRequestHeaders__ServiceDescriptor;
import io.helidon.service.registry.Scope;
import io.helidon.service.registry.Scopes;
import io.helidon.service.registry.Service;
import io.helidon.webserver.http.Filter;
import io.helidon.webserver.http.FilterChain;
import io.helidon.webserver.http.RoutingRequest;
import io.helidon.webserver.http.RoutingResponse;
import io.helidon.webserver.http.ServerRequest__ServiceDescriptor;
import io.helidon.webserver.http.ServerResponse__ServiceDescriptor;
import io.helidon.webserver.spi.ServerFeature;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

@Weight(value=1000.0)
public class RequestScopeFeature
implements ServerFeature {
    private final boolean enabled;
    private final Supplier<Scopes> scopes;

    private RequestScopeFeature(Supplier<Scopes> scopes, boolean enabled) {
        this.enabled = enabled;
        this.scopes = scopes;
    }

    public static RequestScopeFeature create(Supplier<Scopes> scopes, boolean enabled) {
        return new RequestScopeFeature(scopes, enabled);
    }

    @Override
    public void setup(ServerFeature.ServerFeatureContext featureContext) {
        if (this.enabled) {
            Set<String> sockets = featureContext.sockets();
            RequestScopeFilter filter = new RequestScopeFilter(this.scopes.get());
            for (String socket : sockets) {
                featureContext.socket(socket).httpRouting().addFilter(filter);
            }
            featureContext.socket("@default").httpRouting().addFilter(filter);
        }
    }

    public String name() {
        return "request-scope";
    }

    public String type() {
        return "request-scope";
    }

    private static class RequestScopeFilter
    implements Filter {
        private final Scopes scopes;

        private RequestScopeFilter(Scopes scopes) {
            this.scopes = scopes;
        }

        @Override
        public void filter(FilterChain chain, RoutingRequest req, RoutingResponse res) {
            try (Scope ignored = this.startRequestScope(req, res);){
                chain.proceed();
            }
        }

        private Scope startRequestScope(RoutingRequest req, RoutingResponse res) {
            return this.scopes.createScope(Service.PerRequest.TYPE, "http_" + req.id(), Map.of(HttpPrologue__ServiceDescriptor.INSTANCE, req.prologue(), Headers__ServiceDescriptor.INSTANCE, req.headers(), ServerRequestHeaders__ServiceDescriptor.INSTANCE, req.headers(), ServerRequest__ServiceDescriptor.INSTANCE, req, ServerResponse__ServiceDescriptor.INSTANCE, res));
        }
    }
}

