/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.list.primitive;

import java.util.Objects;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.block.function.primitive.BooleanIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanIntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanBooleanProcedure;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.primitive.ImmutableBooleanList;
import org.eclipse.collections.api.ordered.primitive.ReversibleBooleanIterable;
import org.eclipse.collections.api.tuple.primitive.BooleanBooleanPair;
import org.eclipse.collections.api.tuple.primitive.BooleanObjectPair;

public interface BooleanList
extends ReversibleBooleanIterable {
    public boolean get(int var1);

    public int lastIndexOf(boolean var1);

    @Override
    public BooleanList select(BooleanPredicate var1);

    @Override
    public BooleanList reject(BooleanPredicate var1);

    @Override
    default public BooleanList tap(BooleanProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    default public void forEachInBoth(BooleanList other, BooleanBooleanProcedure procedure) {
        Objects.requireNonNull(other);
        if (this.size() != other.size()) {
            throw new IllegalArgumentException("Attempt to call forEachInBoth with two BooleanList instances of different sizes :" + this.size() + ":" + other.size());
        }
        this.forEachWithIndex((each, index) -> procedure.value(each, other.get(index)));
    }

    @Override
    default public BooleanList selectWithIndex(BooleanIntPredicate predicate) {
        int[] index = new int[]{0};
        return this.select(each -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each, n);
        });
    }

    @Override
    default public BooleanList rejectWithIndex(BooleanIntPredicate predicate) {
        int[] index = new int[]{0};
        return this.reject(each -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each, n);
        });
    }

    public <V> ListIterable<V> collect(BooleanToObjectFunction<? extends V> var1);

    default public <V> ListIterable<V> collectWithIndex(BooleanIntToObjectFunction<? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((boolean each) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.value(each, n);
        });
    }

    public boolean equals(Object var1);

    public int hashCode();

    public ImmutableBooleanList toImmutable();

    @Override
    public BooleanList distinct();

    @Override
    public BooleanList toReversed();

    public BooleanList subList(int var1, int var2);

    default public ListIterable<BooleanBooleanPair> zipBoolean(BooleanIterable iterable) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    default public <T> ListIterable<BooleanObjectPair<T>> zip(Iterable<T> iterable) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }
}

