/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.types.ModuleInfoExportsBlueprint;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public interface ModuleInfoExports
extends ModuleInfoExportsBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ModuleInfoExports instance) {
        return (Builder)ModuleInfoExports.builder().from(instance);
    }

    public static ModuleInfoExports create() {
        return ModuleInfoExports.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, ModuleInfoExports>
    implements io.helidon.common.Builder<Builder, ModuleInfoExports> {
        private Builder() {
        }

        public ModuleInfoExports buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ModuleInfoExportsImpl(this);
        }

        public ModuleInfoExports build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ModuleInfoExports>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final List<String> targets = new ArrayList<String>();
        private boolean isTargetsMutated;
        private String packageName;

        protected BuilderBase() {
        }

        public BUILDER from(ModuleInfoExports prototype) {
            this.packageName(prototype.packageName());
            if (!this.isTargetsMutated) {
                this.targets.clear();
            }
            this.addTargets(prototype.targets());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.packageName().ifPresent(this::packageName);
            if (this.isTargetsMutated) {
                if (builder.isTargetsMutated) {
                    this.addTargets(builder.targets);
                }
            } else {
                this.targets.clear();
                this.addTargets(builder.targets);
            }
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER packageName(String packageName) {
            Objects.requireNonNull(packageName);
            this.packageName = packageName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER targets(List<String> targets) {
            Objects.requireNonNull(targets);
            this.isTargetsMutated = true;
            this.targets.clear();
            this.targets.addAll(targets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addTargets(List<String> targets) {
            Objects.requireNonNull(targets);
            this.isTargetsMutated = true;
            this.targets.addAll(targets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addTarget(String target) {
            Objects.requireNonNull(target);
            this.targets.add(target);
            this.isTargetsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> packageName() {
            return Optional.ofNullable(this.packageName);
        }

        public List<String> targets() {
            return this.targets;
        }

        public String toString() {
            return "ModuleInfoExportsBuilder{packageName=" + this.packageName + ",targets=" + String.valueOf(this.targets) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.packageName == null) {
                collector.fatal(this.getClass(), "Property \"packageName\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class ModuleInfoExportsImpl
        implements ModuleInfoExports {
            private final List<String> targets;
            private final String packageName;

            protected ModuleInfoExportsImpl(BuilderBase<?, ?> builder) {
                this.packageName = builder.packageName().get();
                this.targets = List.copyOf(builder.targets());
            }

            @Override
            public String packageName() {
                return this.packageName;
            }

            @Override
            public List<String> targets() {
                return this.targets;
            }

            public String toString() {
                return "ModuleInfoExports{packageName=" + this.packageName + ",targets=" + String.valueOf(this.targets) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ModuleInfoExports)) {
                    return false;
                }
                ModuleInfoExports other = (ModuleInfoExports)o;
                return Objects.equals(this.packageName, other.packageName()) && Objects.equals(this.targets, other.targets());
            }

            public int hashCode() {
                return Objects.hash(this.packageName, this.targets);
            }
        }
    }
}

