/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.transaction.ExchangeRateSet;
import com.hedera.node.app.blocks.impl.BlockStreamBuilder;
import com.hedera.node.app.spi.records.RecordSource;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.app.state.HederaRecordCache;
import com.hedera.node.app.state.SingleTransactionRecord;
import com.hedera.node.app.state.recordcache.BlockRecordSource;
import com.hedera.node.app.state.recordcache.LegacyListRecordSource;
import com.hedera.node.app.workflows.handle.HandleWorkflow;
import com.hedera.node.app.workflows.handle.record.RecordStreamBuilder;
import com.hedera.node.app.workflows.handle.steps.ParentTxn;
import com.hedera.node.config.types.StreamMode;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public record HandleOutput(@Nullable BlockRecordSource blockRecordSource, @Nullable RecordSource recordSource, @NonNull Instant lastAssignedConsensusTime) {
    public HandleOutput {
        if (blockRecordSource == null) {
            Objects.requireNonNull(recordSource);
        }
        Objects.requireNonNull(lastAssignedConsensusTime);
    }

    public static HandleOutput failInvalidStreamItems(@NonNull ParentTxn parentTxn, @NonNull ExchangeRateSet exchangeRates, @NonNull StreamMode streamMode, @NonNull HederaRecordCache recordCache) {
        BlockRecordSource blockRecordSource;
        LegacyListRecordSource recordSource;
        Objects.requireNonNull(parentTxn);
        Objects.requireNonNull(exchangeRates);
        Objects.requireNonNull(streamMode);
        parentTxn.stack().rollbackFullStack();
        Object cacheableRecordSource = null;
        if (streamMode != StreamMode.BLOCKS) {
            RecordStreamBuilder failInvalidBuilder = new RecordStreamBuilder(StreamBuilder.ReversingBehavior.REVERSIBLE, StreamBuilder.SignedTxCustomizer.NOOP_SIGNED_TX_CUSTOMIZER, HandleContext.TransactionCategory.USER);
            HandleWorkflow.initializeBuilderInfo(failInvalidBuilder, parentTxn.txnInfo(), exchangeRates).status(ResponseCodeEnum.FAIL_INVALID).consensusTimestamp(parentTxn.consensusNow());
            SingleTransactionRecord failInvalidRecord = failInvalidBuilder.build();
            cacheableRecordSource = recordSource = new LegacyListRecordSource(List.of(failInvalidRecord), List.of(new RecordSource.IdentifiedReceipt(failInvalidRecord.transactionRecord().transactionIDOrThrow(), failInvalidRecord.transactionRecord().receiptOrThrow())));
        } else {
            recordSource = null;
        }
        if (streamMode != StreamMode.RECORDS) {
            LinkedList<BlockStreamBuilder.Output> outputs = new LinkedList<BlockStreamBuilder.Output>();
            BlockStreamBuilder failInvalidBuilder = new BlockStreamBuilder(StreamBuilder.ReversingBehavior.REVERSIBLE, StreamBuilder.SignedTxCustomizer.NOOP_SIGNED_TX_CUSTOMIZER, HandleContext.TransactionCategory.USER);
            HandleWorkflow.initializeBuilderInfo(failInvalidBuilder, parentTxn.txnInfo(), exchangeRates).status(ResponseCodeEnum.FAIL_INVALID).consensusTimestamp(parentTxn.consensusNow());
            outputs.add(failInvalidBuilder.build(true, null));
            blockRecordSource = new BlockRecordSource(outputs);
            cacheableRecordSource = blockRecordSource;
        } else {
            blockRecordSource = null;
        }
        recordCache.addRecordSource(parentTxn.creatorInfo().nodeId(), Objects.requireNonNull(parentTxn.txnInfo().transactionID()), HederaRecordCache.DueDiligenceFailure.NO, Objects.requireNonNull(cacheableRecordSource));
        return new HandleOutput(blockRecordSource, recordSource, parentTxn.consensusNow());
    }

    @NonNull
    public RecordSource recordSourceOrThrow() {
        return Objects.requireNonNull(this.recordSource);
    }

    @NonNull
    public BlockRecordSource blockRecordSourceOrThrow() {
        return Objects.requireNonNull(this.blockRecordSource);
    }

    @NonNull
    public RecordSource preferringBlockRecordSource() {
        return this.blockRecordSource != null ? this.blockRecordSource : Objects.requireNonNull(this.recordSource);
    }
}

