/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaNativeOperations;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ApprovalSwitchHelper {
    public static final ApprovalSwitchHelper APPROVAL_SWITCH_HELPER = new ApprovalSwitchHelper();

    private ApprovalSwitchHelper() {
    }

    public CryptoTransferTransactionBody switchToApprovalsAsNeededIn(@NonNull CryptoTransferTransactionBody original, @NonNull Predicate<Key> signatureTest, @NonNull HederaNativeOperations nativeOperations, @NonNull AccountID senderId) {
        Objects.requireNonNull(original);
        Objects.requireNonNull(senderId);
        Objects.requireNonNull(signatureTest);
        Objects.requireNonNull(nativeOperations);
        CryptoTransferTransactionBody.Builder revision = CryptoTransferTransactionBody.newBuilder();
        if (original.hasTransfers()) {
            List originalAdjusts = original.transfersOrThrow().accountAmounts();
            revision.transfers(TransferList.newBuilder().accountAmounts(this.revisedAdjusts(originalAdjusts, signatureTest, nativeOperations, senderId)).build());
        }
        List originalTokenTransfers = original.tokenTransfers();
        TokenTransferList[] revisedTokenTransfers = new TokenTransferList[originalTokenTransfers.size()];
        int n = originalTokenTransfers.size();
        for (int i = 0; i < n; ++i) {
            TokenTransferList originalTokenTransfer = (TokenTransferList)originalTokenTransfers.get(i);
            TokenTransferList.Builder revisedTokenTransfer = TokenTransferList.newBuilder().token(originalTokenTransfer.token());
            if (originalTokenTransfer.transfers().isEmpty()) {
                revisedTokenTransfer.nftTransfers(this.revisedOwnershipChanges(originalTokenTransfer.nftTransfers(), signatureTest, nativeOperations, senderId));
            } else {
                revisedTokenTransfer.transfers(this.revisedAdjusts(originalTokenTransfer.transfers(), signatureTest, nativeOperations, senderId));
            }
            revisedTokenTransfers[i] = revisedTokenTransfer.build();
        }
        revision.tokenTransfers(revisedTokenTransfers);
        return revision.build();
    }

    private AccountAmount[] revisedAdjusts(@NonNull List<AccountAmount> original, @NonNull Predicate<Key> signatureTest, @NonNull HederaNativeOperations nativeOperations, @NonNull AccountID senderId) {
        AccountAmount[] revision = new AccountAmount[original.size()];
        int n = original.size();
        for (int i = 0; i < n; ++i) {
            revision[i] = this.revisedAdjust(original.get(i), signatureTest, nativeOperations, senderId);
        }
        return revision;
    }

    private AccountAmount revisedAdjust(@NonNull AccountAmount original, @NonNull Predicate<Key> signatureTest, @NonNull HederaNativeOperations nativeOperations, @NonNull AccountID senderId) {
        if (original.amount() < 0L) {
            AccountID debitedAccountId = original.accountIDOrThrow();
            if (senderId.equals((Object)debitedAccountId)) {
                return original;
            }
            Key key = nativeOperations.getAccountKey(debitedAccountId);
            if (key != null && !signatureTest.test(key)) {
                return original.copyBuilder().isApproval(true).build();
            }
        }
        return original;
    }

    private NftTransfer[] revisedOwnershipChanges(@NonNull List<NftTransfer> original, @NonNull Predicate<Key> signatureTest, @NonNull HederaNativeOperations nativeOperations, @NonNull AccountID senderId) {
        NftTransfer[] revision = new NftTransfer[original.size()];
        int n = original.size();
        for (int i = 0; i < n; ++i) {
            revision[i] = this.revisedNftTransfer(original.get(i), signatureTest, nativeOperations, senderId);
        }
        return revision;
    }

    private NftTransfer revisedNftTransfer(@NonNull NftTransfer original, @NonNull Predicate<Key> signatureTest, @NonNull HederaNativeOperations nativeOperations, @NonNull AccountID senderId) {
        AccountID transferAccountId = original.senderAccountIDOrThrow();
        if (senderId.equals((Object)transferAccountId)) {
            return original;
        }
        Key key = nativeOperations.getAccountKey(transferAccountId);
        if (key != null && !signatureTest.test(key)) {
            return original.copyBuilder().isApproval(true).build();
        }
        return original;
    }
}

