/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.state;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.state.contract.Bytecode;
import com.hedera.hapi.node.state.contract.SlotKey;
import com.hedera.hapi.node.state.contract.SlotValue;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.contract.impl.schemas.V0490ContractSchema;
import com.hedera.node.app.service.contract.impl.state.ContractStateStore;
import com.hedera.node.app.service.entityid.ReadableEntityCounters;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class ReadableContractStateStore
implements ContractStateStore {
    private final ReadableKVState<SlotKey, SlotValue> storage;
    private final ReadableKVState<ContractID, Bytecode> bytecode;
    private final ReadableEntityCounters entityCounters;

    public ReadableContractStateStore(@NonNull ReadableStates states, @NonNull ReadableEntityCounters entityCounters) {
        Objects.requireNonNull(states);
        this.entityCounters = Objects.requireNonNull(entityCounters);
        this.storage = states.get(V0490ContractSchema.STORAGE_STATE_ID);
        this.bytecode = states.get(V0490ContractSchema.BYTECODE_STATE_ID);
    }

    @Override
    public Bytecode getBytecode(@NonNull ContractID contractId) {
        return (Bytecode)this.bytecode.get((Object)contractId);
    }

    @Override
    public void putBytecode(@NonNull ContractID contractId, @NonNull Bytecode code) {
        throw new UnsupportedOperationException("Cannot put bytecode in a read-only store");
    }

    @Override
    public void removeSlot(@NonNull SlotKey key) {
        throw new UnsupportedOperationException("Cannot remove slots from a read-only store");
    }

    @Override
    public void adjustSlotCount(long delta) {
        throw new UnsupportedOperationException("Cannot adjust slot count in a read-only store");
    }

    @Override
    public void putSlot(@NonNull SlotKey key, @NonNull SlotValue value) {
        throw new UnsupportedOperationException("Cannot put slots in a read-only store");
    }

    @Override
    public Set<SlotKey> getModifiedSlotKeys() {
        return Collections.emptySet();
    }

    @Override
    @Nullable
    public SlotValue getSlotValue(@NonNull SlotKey key) {
        return (SlotValue)this.storage.get((Object)key);
    }

    @Override
    @Nullable
    public SlotValue getOriginalSlotValue(@NonNull SlotKey key) {
        return (SlotValue)this.storage.get((Object)key);
    }

    @Override
    public long getNumSlots() {
        return this.entityCounters.getCounterFor(EntityType.CONTRACT_STORAGE);
    }

    @Override
    public long getNumBytecodes() {
        return this.entityCounters.getCounterFor(EntityType.CONTRACT_BYTECODE);
    }
}

